/*
Copyright (c) 1998-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	traceco.h	Include file for traceco module.
*/

#ifndef TRACECO_INC
#define TRACECO_INC 1

#include <dk.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#if DK_HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_DIRENT_H
#include <dirent.h>
#endif
#if DK_HAVE_IO_H
#include <io.h>
#endif
#if DK_HAVE_DIR_H
#include <dir.h>
#endif
#if DK_HAVE_DIRECT_H
#include <direct.h>
#endif

#include <troutput.h>

/**	Command buffer size. */
#define TRACE_CMD_BUFFER_SIZE 2048

/**	Character introducing tracecc control instruction. */
#define TRACE_CONTROL '$'

#ifndef MAXPATHLEN
/**	maximum path length for file names. */
#define MAXPATHLEN 1024
#endif


/**	Trana job.
 */
typedef struct {
  kOutputData *outData;			/**< Outpu data. */
  /* kTca     automat; */
  int     automat;			/**< Current state. */
  char    filename1[MAXPATHLEN];	/**< File name 1. */
  char    filename2[MAXPATHLEN];	/**< File name 2. */
  char    filename3[MAXPATHLEN];	/**< File name 3. */
  FILE   *inputFile;			/**< Input file. */
  FILE   *outputFile;			/**< Output file. */
  FILE   *tempFile;			/**< Temporary file. */
  int     mode;				/**< Run mode. */
  char    currentChar;			/**< Current character to process. */
  int     originalModus;		/**< Original mode. */
  int     lineNumber;			/**< Current line number. */
  int     lineIndent;			/**< Line indent. */
  int     lineTextFound;		/**< Flag: Text found in line. */
  char    cmdBuffer[TRACE_CMD_BUFFER_SIZE];	/**< Command buffer. */
  char    *ptrBuffer;			/**< Pointer to buffer. */
  int     inBuffer;			/**< Characters in buffer. */
  int     currentLineLength;		/**< Length of current line. */
  int     maxLineLength;		/**< Maximum line length. */
  int     boxWidth;			/**< Box width. */
  int     day;				/**< Day. */
  int     month;			/**< Month. */
  int     year;				/**< Year. */
  int     hour;				/**< Hour. */
  int     min;				/**< Minute. */
  int     sec;				/**< Second. */
  /* kStorage methods; */
  char    *shortFileNamePointer;	/**< Pointer to short file name. */
} kTraceCodeData;



#if DK_HAVE_PROTOTYPES
#if defined(__cplusplus)
extern "C" {
#endif
/**	Run with arguments.
 * 	@param	traceCode	Trace Code data.
 * 	@param	output		Output data.
 * 	@param	argc		Number of command line arguments.
 * 	@param	argv		Command line arguments array.
 * 	@return	Success flag.
 */
int kTraceCodeRunArg(
  kTraceCodeData *traceCode, kOutputData *output,
  int argc,                  char *argv[]
);
#if defined(__cplusplus)
}
#endif
#else
#ifndef TRACECO_C
int void kTraceCodeRunArg();
#endif
#endif


#endif

