/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/


#include "dk.h"

#include <stdio.h>

#if DK_HAVE_STRING_H
#include <string.h>
#endif

#if DK_HAVE_IO_H
#include <io.h>
#endif

#if DK_HAVE_DIRECT_H
#include <direct.h>
#endif

#if DK_HAVE_CONIO_H
#include <conio.h>
#endif

#if (!DK_HAVE_POPEN) && DK_HAVE__POPEN
#ifdef __cplusplus
extern "C" {
#endif
FILE *popen(char *cmd, char *mode);
#ifdef __cplusplus
}
#endif
FILE *
popen DK_P2(char *,cmd, char *,mode)
{
  FILE *back = NULL;
  if(cmd && mode) {
    back = _popen(cmd, mode);
  }
  return back;
}
#endif

#if (!DK_HAVE_STRICMP) && DK_HAVE__STRICMP
#ifdef __cplusplus
extern "C" {
#endif
int stricmp(char *s1, char *s2);
#ifdef __cplusplus
}
#endif
int
stricmp DK_P2(char *,s1, char *,s2)
{
  int back = 0;
  if(s1 && s2) {
    back = _stricmp(s1,s2);
  }
  return back;
}
#endif

#if (!DK_HAVE_UNLINK) && DK_HAVE__UNLINK
#ifdef __cplusplus
extern "C" {
#endif
int unlink(char *fn);
#ifdef __cplusplus
}
#endif
int
unlink DK_P1(char *,fn)
{
  int back = 0;
  if(fn) {
    back = _unlink(fn);
  }
  return back;
}
#endif

#if (!DK_HAVE_RMDIR) && DK_HAVE__RMDIR
#ifdef __cplusplus
extern "C" {
#endif
int rmdir(char *dn);
#ifdef __cplusplus
}
#endif
int
rmdir DK_P1(char *,dn)
{
  int back = 0;
  if(dn) {
    back = _rmdir(dn);
  }
  return back;
}
#endif

#if (!DK_HAVE_FILENO) && DK_HAVE__FILENO
#ifdef __cplusplus
extern "C" {
#endif
int fileno(FILE *f);
#ifdef __cplusplus
}
#endif
int
fileno DK_P1(FILE *,f)
{
  int back = -1;
  if(f) {
    back = _fileno(f);
  }
  return back;
}
#endif

#if (!DK_HAVE_STAT) && DK_HAVE__STAT
#ifdef __cplusplus
extern "C" {
#endif
int stat(char *fn, struct _stat *buf);
#ifdef __cplusplus
}
#endif
int
stat DK_P2(char *,fn, struct _stat *,buf)
{
  int back = -1;
  if(fn && buf) {
    back = _stat(fn, buf);
  }
  return back;
}
#endif

#if (!DK_HAVE_MKDIR) && DK_HAVE__MKDIR
#ifdef __cplusplus
extern "C" {
#endif
int mkdir(char *dn);
#ifdef __cplusplus
}
#endif
int
mkdir DK_P1(char *,dn)
{
  int back = -1;
  if(dn) {
    back = _mkdir(dn);
  }
  return back;
}
#endif

#if (!DK_HAVE_KBHIT) && DK_HAVE__KBHIT
#ifdef __cplusplus
extern "C" {
#endif
int kbhit(void);
#ifdef __cplusplus
}
#endif
int
kbhit DK_P0()
{
  int back;
  back = _kbhit();
  return back;
}
#endif

#if (!DK_HAVE_GETCH) && DK_HAVE__GETCH
#ifdef __cplusplus
extern "C" {
#endif
int getch(void);
#ifdef __cplusplus
}
#endif
int
getch DK_P0()
{
  int back = 0;
  back = _getch();
  return back;
}
#endif

#if (!DK_HAVE_SETMODE) && DK_HAVE__SETMODE
#ifdef __cplusplus
extern "C" {
#endif
int setmode(int h, int m);
#ifdef __cplusplus
}
#endif
int
setmode DK_P2(int,h, int,m)
{
  int back = -1;
  back = _setmode(h,m);
  return back;
}

#if (!DK_HAVE_FDOPEN) && DK_HAVE__FDOPEN
#ifdef __cplusplus
extern "C" {
#endif
FILE *fdopen(int h, char *m);
#ifdef __cplusplus
}
#endif
FILE *
fdopen DK_P2(int,h, char *,m)
{
  FILE *back = NULL;
  if(m) {
    back = _fdopen(h,m);
  }
  return back;
}
#endif

#endif

