package netgroup;

# new <name>

sub new
{
  my $class = shift;
  my $self  = {};
  $self->{'hostnames'} = {};
  $self->{'subgroups'} = {};
  $self->{'name'} = '';
  $self->{'hosts'} = {};
  $self->{'comment'} = undef;
  bless($self,$class);
  return $self;
}

sub get_hostnames
{
  my $self = shift;
  my $back = $self->{'hostnames'};
  return $back;
}

sub get_subgroups
{
  my $self = shift;
  my $back = $self->{'subgroups'};
  return $back;
}

# We are the parent group, the second argument contains
# the child groups
#
sub set_subgroup
{
  my $self = shift;
  my $name = shift;
  my $sg = $self->{'subgroups'};
  $sg->{"$name"} = 1;
}

sub add_subgroups
{
  my $self = shift;
  my $line = shift;
  my $name = "";
  $line =~ s/^\s+//go;
  chomp $line;
  while($line =~ /\S/o) {
    if($line =~ /(\S+)\s+(\S.*)/o) {
      $name = $1; $line = $2;
      $self->set_subgroup($name);
    } else {
      $name = $line; $line = "";
      $self->set_subgroup($name);
    }
  }
}

sub set_name
{
  my $self = shift;
  my $name = shift;
  $self->{'name'} = $name;
}

sub get_name
{
  my $self = shift;
  my $back = $self->{'name'};
  return $back;
}

sub add_host
{
  my $self = shift;
  my $name = shift;
  my $href = $self->{'hosts'};
  $href->{"$name"} = 1;
}

sub get_hosts
{
  my $self = shift;
  my $back = $self->{'hosts'};
  return $back;
}

sub get_number_of_hosts
{
  my $self = shift;
  my $back = 0;
  my $i;
  my $hostref;
  my $hosts = $self->{'hosts'};
  foreach $i (keys %$hosts) {
    $back++;
    # {{{
    $hostref = $hosts{"$i"};
    if($hostref) {
      if($hostref->get_full_name_first()) {
	$back++;
      }
    }
    # }}}
  }
  return $back;
}

sub get_number_of_subgroups
{
  my $self = shift;
  my $back = 0;
  my $i;
  my $hosts = $self->{'subgroups'};
  foreach $i (keys %$hosts) { $back++; }
  return $back;
}

sub set_comment
{
  my $self = shift; my $comm = shift;
  $self->{'comment'} = $comm;
}

sub get_comment
{
  my $self = shift;
  my $back = $self->{'comment'};
  return $back;
}

1;

