/* ********************************************************************* */
/* *                                                                   * */
/* * Copyright (c) 2010 - Dipl.-Ing. Dirk Krause                       * */
/* *                                                                   * */
/* * All rights reserved.                                              * */
/* *                                                                   * */
/* * Redistribution and use in source and binary forms,                * */
/* * with or without modification, are permitted provided              * */
/* * that the following conditions are met:                            * */
/* *                                                                   * */
/* * * Redistributions of source code must retain the above            * */
/* *   copyright notice, this list of conditions and the               * */
/* *   following disclaimer.                                           * */
/* * * Redistributions in binary form must reproduce the above         * */
/* *   opyright notice, this list of conditions and the following      * */
/* *   disclaimer in the documentation and/or other materials          * */
/* *   provided with the distribution.                                 * */
/* * * Neither the name of Dirk Krause nor the names of                * */
/* *   contributors may be used to endorse or promote                  * */
/* *   products derived from this software without specific            * */
/* *   prior written permission.                                       * */
/* *                                                                   * */
/* * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            * */
/* * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       * */
/* * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          * */
/* * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          * */
/* * DISCLAIMED.                                                       * */
/* * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE          * */
/* * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,             * */
/* * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           * */
/* * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          * */
/* * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)          * */
/* * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN         * */
/* * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE         * */
/* * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS           * */
/* * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH              * */
/* * DAMAGE.                                                           * */
/* *                                                                   * */
/* ********************************************************************* */


/**	@file	kwt1.c	Support functions for kwintool, module 1.
*/


#include "kwintool.h"




#line 50 "kwt1.ctr"




void *
kwt_alloc(size_t elsize, size_t nelem)
{
  void *back = NULL;
  size_t lgt;
  lgt = elsize * nelem;
  back = (void *)LocalAlloc((LMEM_FIXED | LMEM_ZEROINIT), lgt);
  return back;
}


void
kwt_free(void *p)
{
  if(p) {
    LocalFree((HLOCAL)p);
  }
}



OLEL *
kwt_olel_new(WCHAR const *n)
{
  OLEL *back = NULL;
  back = kwt_alloc(sizeof(OLEL),1);
  if(back) {
    back->jobid = 0L;
    back->name = NULL;
    back->next = NULL;
    if(n) {
      back->name = wstr_dup(n);
      if(!(back->name)) {
        kwt_free(back); back = NULL;
      }
    }
  }
  return back;
}



OLEL *
kwt_olel_chain_new(WCHAR const *n, OLEL *oldroot)
{
  OLEL *back = NULL;
  back = kwt_olel_new(n);
  if(back) {
    back->next = oldroot;
  }
  return back;
}



void
kwt_olel_delete(OLEL *p)
{
  if(p->name) {
    kwt_free(p->name);
  }
  kwt_free(p);
}


void
kwt_olel_chain_delete(OLEL *root)
{
  OLEL *c, *p;
  c = root;
  while(c) {
    p = c->next;
    kwt_olel_delete(c);
    c = p;
  }
}


OLEL *
kwt_olel_chain_find(OLEL *r, WCHAR const *n, int cs)
{
  OLEL *back = NULL;
  OLEL *c, *p;
  c = r;
  while((c) && (!(back))) {
    p = c->next;
    if(c->name) {
      if(cs) {
        if(wcscmp(c->name, n) == 0) {
	  back = c;
	}
      } else {
        if(_wcsicmp(c->name, n) == 0) {
	  back = c;
	}
      }
    }
    c = p;
  }
  return back;
}


