/* ********************************************************************* */
/* *                                                                   * */
/* * Copyright (c) 2010 - Dipl.-Ing. Dirk Krause                       * */
/* *                                                                   * */
/* * All rights reserved.                                              * */
/* *                                                                   * */
/* * Redistribution and use in source and binary forms,                * */
/* * with or without modification, are permitted provided              * */
/* * that the following conditions are met:                            * */
/* *                                                                   * */
/* * * Redistributions of source code must retain the above            * */
/* *   copyright notice, this list of conditions and the               * */
/* *   following disclaimer.                                           * */
/* * * Redistributions in binary form must reproduce the above         * */
/* *   opyright notice, this list of conditions and the following      * */
/* *   disclaimer in the documentation and/or other materials          * */
/* *   provided with the distribution.                                 * */
/* * * Neither the name of Dirk Krause nor the names of                * */
/* *   contributors may be used to endorse or promote                  * */
/* *   products derived from this software without specific            * */
/* *   prior written permission.                                       * */
/* *                                                                   * */
/* * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            * */
/* * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       * */
/* * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          * */
/* * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          * */
/* * DISCLAIMED.                                                       * */
/* * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE          * */
/* * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,             * */
/* * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT           * */
/* * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          * */
/* * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)          * */
/* * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN         * */
/* * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE         * */
/* * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS           * */
/* * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH              * */
/* * DAMAGE.                                                           * */
/* *                                                                   * */
/* ********************************************************************* */

/**	@file	kwintool.h	Main include file for kwintool.
*/


#ifndef KWINTOOL_H_INCLUDED
#define KWINTOOL_H_INCLUDED	1


/*
 	XP Prof specific functions are needed.
*/
#define _WIN32_WINNT 0x0501
#define WINVER 0x0501
#define NTDDI_VERSION	NTDDI_WINXPSP2

/*
 	Make sure to use the correct
	character sizes
*/
#ifdef MBCS
#undef MBCS
#endif
#ifdef _MBCS
#undef _MBCS
#endif
#ifndef UNICODE
#define UNICODE		1
#endif
#ifndef _UNICODE
#define _UNICODE	1
#endif



/*
 	All the include files
*/
#include <winsock2.h>
#include <windows.h>
#include <winbase.h>
#include <winwlx.h>
#include <winuser.h>
#include <lm.h>
#include <memory.h>
#include <tchar.h>
#include <wchar.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <time.h>
#include <process.h>
#include <stddef.h>
#include <conio.h>

/**	One list element to delete a print job.
*/
struct _one_list_element_ {
  	DWORD				jobid;	/**< Print job ID. */
  	WCHAR				*name;	/**< User/job name. */
	struct _one_list_element_	*next;	/**< Next element. */
}; typedef struct _one_list_element_ OLEL;


/**	Function, used to traverse directories
*/
typedef int FCT_TRAVERSE(void *dataptr, WCHAR *fn, int is_dir, int is_base);


#ifdef __cplusplus
extern "C" {
#endif


/**	Memory allocation.
	@param	elsize	Size of one element.
	@param	nelem	Number of elements.
	@return	Pointer to allocated memory on success, NULL on error.
*/
void *
  kwt_alloc(size_t elsize, size_t nelem);

/**	Release memory allocated by kwt_alloc().
	@param	p	Pointer to memory.
*/
void
  kwt_free(void *p);

/**	Remove print jobs of current user in the specified LPD queues.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
*/
void
  kwt_run_lprm_lpd(int argc, WCHAR const * const *argv);

/**	Remove print jobs of current users from the given queues.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
*/
void
  kwt_run_lprm_local(int argc, WCHAR const * const *argv);

/**	Create new node for chain (linked list).
	@param	n	Name for node.
	@return	Pointer to new node on success, NULL on error.
*/
OLEL *
  kwt_olel_new(WCHAR const *n);

/**	Delete one node from chain (linked list), release memory.
	@param	p	Pointer to node to release.
*/
void
  kwt_olel_delete(OLEL *p);

/**	Insert new name into a chain (linked list).
	@param	n	Name.
	@param	oldroot	Previous root node (may be NULL when inserting first element).
	@eturn	New root node on success, NULL on error.
*/
OLEL *
  kwt_olel_chain_new(WCHAR const *n, OLEL *oldroot);

/**	Delete entire chain (linked list), rlease memory.
	@param	root	Root node.
*/
void
  kwt_olel_chain_delete(OLEL *root);

/**	Find list node for a given name in a chain (linked list).
	@param	r	List root (First element).
	@param	n	Name to find.
	@param	cs	Flag: case-sensitive (1) no insensitive (0).
	@return	Pointer to node on success, NULL on error.
*/
OLEL *
  kwt_olel_chain_find(OLEL *r, WCHAR const *n, int cs);



/**	Inspect whether or not a character is a whitespace.
	@paramc	c	Character to inspect.
	@return	Non-zero value for whitespace, 0 for other characters.
*/
int
  whstr_is_whsp(WCHAR c);

/**	Find start of text (first non-whitespace).
	@param	s	String to inspect.
	@return	Pointer on success, NULL on error.
*/
WCHAR *
  wstr_start(WCHAR const *s);

/**	Find start of next non-whitespace sequence.
	@param	s	String to inspect.
	@return	Pointer on success, NULL on error.
*/
WCHAR *
  wstr_next(WCHAR *s);

/**	Remove trailing whitespaces from string.
	@param	s	String to process.
	@return	1 if there is at least one non-whitespace, 0 otherwise
*/
int
  wstr_chomp(WCHAR *s);

/**	Find index of string \a s in array \a a.
 	@param	s	String to search for.
	@param	a	Array of strings.
	@return	Index of \a s in \a a on success, -1 on error (not found).
*/
int
  wstr_array_index(WCHAR const * const *a, WCHAR const *s);

/**	Duplicate string.
	@param	s	Source string.
	@return	Pointer to duplicate on success, NULL on error.
*/
WCHAR *
  wstr_dup(WCHAR const *s);

/**	Set exit code.
	@param	i	Exit code.
*/
void
  kwt_set_exval(int i);

/**	Process one boot, login, logout or shutdown event.
	@param	stage	Event type: 0=boot, 1=login, 2=logout, 3=shutdown.
*/
void
  kwt_boot_login_logout_shutdown(int stage);

/**	Show all entries in a specified directory.
 	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
*/
void
  kwt_ls(int argc, WCHAR **argv);

/**	Disable cleanup until next user logged in and logged out. */
void
  kwt_no_cleanup(void);

/**	Re-enable cleanup manually. */
void
  kwt_yes_cleanup(void);

#ifdef __cplusplus
};
#endif


/**	Size of input line buffer.
*/
#define	KWINTOOL_BUFFER_SIZE			1024
	
/**	Size of buffer for computer name.
*/
#define KWINTOOL_COMPUTER_NAME_SIZE		128

/**	Size of buffer for user name.
*/
#define KWINTOOL_USER_NAME_SIZE			128

/**	Buffer size for print job list.
*/
#define KWINTOOL_PRINT_QUEUE_JOB_LIST_SIZE	4096

/**	Number of print jobs (size of buffer for print jobs).
*/
#define KWINTOOL_NUMBER_OF_JOBS			64




#define SIZEOF(v,t) (sizeof(v)/sizeof(t))


typedef WCHAR const * const *KWT_W_CSTR_CPTR;

#define KWINTOOL_DEBUG 0

#endif

