/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	klprm.c	The klprm program.
*/



#include <dk.h>
#include <dkmem.h>
#include <dkstr.h>
#include <dkapp.h>
#include <dktcpip.h>

#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <dktypes.h>

#include <yalc.h>

#include <dklic.h>



#line 62 "klprm.ctr"




/**	Application.
*/
dk_app_t *app = NULL;



/**	System configuration directory.
*/
static char sysconfdir[] = { DK_SYSCONFDIR };



/**	Program group name.
*/
static char prg_group_name[] = { "dktools" };



/**	Type definition necessary to use sizeof() operator.
*/
typedef char *PCHAR;



/**	Default help text, printed if help text file is not found.
*/
static char *help_text[] = {
  "",
  "klprm [-S <server>] [-P <printer>] [-U <user>] [ -a | <jobs> ]",
  "",
  "<server>    connect to the specified server",
  "<printer>   remove jobs from specified print queue",
  "<user>      connect as the named user",
  "<jobs>      jobs to remove (job-id or username)",
  "-a          remove all accessable jobs from printer",
  "",
  NULL
};



/**	Long options.
*/
static char *long_options[] = {
  "s$erver",
  "p$rinter",
  "u$ser",
  "a$ll",
  "h$elp",
  "v$ersion",
  NULL
};



/**	Run normally or print help/version text.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	1 on success, 0 on error.
*/
static
int
run DK_P2(int, argc, char **, argv)
{
  int back = 0;
  char *pchr, **arguments, **lfdptr, **licptr;
  char *printer_name;
  char *user_name;
  char *server_name;
  int  version_wanted, help_wanted;
  int    args_used, have_error;
  int   i, remove_all;
  yalc_rq_t *rq;
  rq = yalc_new();
  if(rq) {
    arguments = dk_new(PCHAR,argc);
    if(arguments) {
      for(i = 0; i < argc; i++) {
	arguments[i] = NULL;
      }
      args_used = 0;
      version_wanted = help_wanted = have_error = 0;
      remove_all = 0;
      printer_name = user_name = server_name = NULL;
      lfdptr = argv;
      i = 1; lfdptr++;
      while(i < argc) {
        pchr = *lfdptr;
	if(*pchr == '-') {
	  pchr++;
	  switch(*pchr) {
	    case '-' : {
	      char *valptr; int whichoption;
	      
	      pchr++;
	      valptr = dkstr_chr(pchr, '=');
	      if(valptr) { *(valptr++) = (char)0; }
	      whichoption = dkstr_array_abbr(long_options, pchr, '$', 0);
	      switch(whichoption) {
	        case 0: {
		  if(valptr) { server_name = valptr; }
		} break;
		case 1: {
		  if(valptr) { printer_name = valptr; }
		} break;
		case 2: {
		  if(valptr) { user_name = valptr; }
		} break;
		case 3: {
		  if(valptr) {
		    remove_all = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    remove_all = 1;
		  }
		} break;
		case 4: {
		  if(valptr) {
		    help_wanted = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    help_wanted = 1;
		  }
		} break;
		case 5: {
		  if(valptr) {
		    version_wanted = (dkstr_is_on(valptr) ? 1 : 0);
		  } else {
		    version_wanted = 1;
		  }
		} break;
	      }
	    } break;
	    case 'a' : {
	      remove_all = 1;
	    } break;
	    case 'P' : {		
	      pchr++;
	      if(!(*pchr)) {
	        i++;
		lfdptr++;
		pchr = NULL;
		if(i < argc) {
		  pchr = *lfdptr;
		}
	      }
	      if(pchr) {
	        if(*pchr) {
		  printer_name = pchr;
		}
	      }
	    } break;
	    case 'H' :
	    case 'S' : {		
	      pchr++;
	      if(!(*pchr)) {
	        i++;
		lfdptr++;
		pchr = NULL;
		if(i < argc) {
		  pchr = *lfdptr;
		}
	      }
	      if(pchr) {
	        if(*pchr) {
		  server_name = pchr;
		}
	      }
	    } break;
	    case 'U' : {		
	      pchr++;
	      if(!(*pchr)) {
	        i++;
		lfdptr++;
		pchr = NULL;
		if(i < argc) {
		  pchr = *lfdptr;
		}
	      }
	      if(pchr) {
	        if(*pchr) {
		  user_name = pchr;
		}
	      }
	    } break;
	    case 'h' : {
	      help_wanted = 1;
	    } break;
	    case 'v' :
	    case 'V' : {
	      version_wanted = 1;
	    } break;
	  }
	} else {
	  arguments[args_used] = dkstr_dup(pchr);
	  if(arguments[args_used]) {
	    args_used++;
	  } else {
	    have_error = 1;
	    dkapp_err_memory(app, sizeof(char), (1+strlen(pchr)));
	  }
	}
        i++; lfdptr++;
      }
      if(!have_error) {
        if(version_wanted || help_wanted) {
	  back = 1;
	  if(version_wanted) {
	    printf("\n");
	    {
	      char **vptr;
	      vptr = yalc_get_version();
	      if(vptr) {
	        while(*vptr) {
	          printf("%s\n", *(vptr++));
	        }
	      }
	    }
	    printf("\nLibraries used:\n\n");
	    licptr = dklic_get();
	    while(*licptr) {
	      printf("%s\n", *(licptr++));
	    }
	    printf("\n");
	  }
	  if(help_wanted) {
	    dkapp_help(app, "klprm.txt", help_text);
	  }
	} else {
          yalc_set_app(rq, app);
          yalc_set_lprm(rq, remove_all);
	  yalc_set_args(rq, args_used, arguments);
	  yalc_set_printer(rq, printer_name);
	  yalc_set_server(rq, server_name);
	  yalc_set_user(rq, user_name);
	  back = yalc_run(rq);
	}
      }
      /* remove arguments */
      for(i = 0; i < argc; i++) {
	pchr = arguments[i];
	if(pchr) { dk_delete(pchr); }
	arguments[i] = NULL;
      }
      dk_delete(arguments);
    } else {
      dkapp_err_memory(app, sizeof(PCHAR), argc);
    }
    yalc_delete(rq); rq = NULL;
  } else {
    dkapp_err_memory(app, sizeof(yalc_rq_t), 1);
  }
  return back;
}



/**	The main() function of the klprm program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv) int argc; char *argv[];
#endif
{
  int back = 0;
  int xargc;
  char **xargv;
  
#line 335 "klprm.ctr"

  app = dkapp_open_ext1(argc, argv, prg_group_name, sysconfdir, 0, 0);
  if(app) {
    if(dktcpip_start()) {
      xargc = dkapp_get_argc(app);
      xargv = dkapp_get_argv(app);
      back = run(xargc, xargv);
      dktcpip_end();
    } else {
      dkapp_err_tcpip(app);
    }
    dkapp_close(app); app = NULL;
  } else {
    fprintf(stderr, "ERROR: Not enough memory!\n"); fflush(stderr);
  }
  back = (back ? 0 : 1);
  
  
#line 352 "klprm.ctr"

  exit(back); return back;
}


