/*
Copyright (c) 2008-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	jlconf.c	The jlconf module of the jlayout program.
*/



#include "jl.h"


#line 47 "jlconf.ctr"




/**	Separator for path name components.
*/
static char sep[] = { "/" };



/**	Default name for configuration file.
*/
static char fn[] = { "jlayout.conf" };



/**	Fold marker preferences key.
*/
static char pn_fold_marker[] = { "/editor/fold-marker" };



/**	Fold marker configuration entry.
*/
static char *cmd_fold_markers[] = {
  "f$old", "m$arkers", NULL
};



/**	Fold marker types.
*/
static char *fold_marker_types[] = {
"no$ne",
"v$im",
"ne$tbeans",
NULL
};



/**	Fold marker options.
*/
static char **cmd_for_options[] = {
cmd_fold_markers,
NULL
};



/**	Set up fold markers.
	@param	j	Jlayout job.
	@param	v	Text containing fold marker setting.
*/
static
void
set_fold_markers DK_P2(JLJ *,j, char *,v) {
  char *p1, *p2;
  int act;
  int fmt;

  fmt = FOLD_MARKER_NONE;
  p1 = dkstr_start(v, NULL);
  while(p1) {
    p2 = dkstr_next(p1, NULL);
    act = dkstr_array_abbr(fold_marker_types, p1, '$', 0);
    switch(act) {
      case 0: {
        fmt = FOLD_MARKER_NONE;
      } break;
      case 1: {
        fmt |= FOLD_MARKER_VIM;
      } break;
      case 2: {
        fmt |= FOLD_MARKER_NETBEANS;
      } break;
    }
    p1 = p2;
  }
  j->foldmt = fmt;
}



/**	Read configuration file.
	@param	j	Jlayout job.
	@param	fn	File name.
*/
static
void
read_config_file DK_P2(JLJ *,j, char *,fn) {
  FILE *f;
  char il[512], *kp, *vp, *parts[16];
  size_t nparts;
  int act;

  f = fopen(fn, "r");
  if(f) {
    while(fgets(il, sizeof(il), f)) {
      dkstr_delcomm(il, '#');
      vp = strchr(il, '=');
      if(vp) {
        *(vp++) = '\0';
	vp = dkstr_start(vp, NULL);
	if(vp) {
	  kp = dkstr_start(il, NULL);
	  if(kp) {
	    dkstr_chomp(kp, NULL);
	    dkstr_chomp(vp, NULL);
	    nparts = dkstr_explode(parts, 15, kp, NULL);
	    if(nparts > 0) {
	      act = dkstr_find_multi_part_abbr(parts, cmd_for_options, '$', 0);
	      switch(act) {
	        case 0: {
		  set_fold_markers(j, vp);
		} break;
	      }
	    }
	  }
	}
      }
    }
    fclose(f);
  }
}



/**	Get base configuration from preferences.
	@param	j	Jlayout job.
*/
static
void
configure_from_application DK_P1(JLJ *,j) {
  char il[512], *p1;
  if(dkapp_get_pref(j->a, pn_fold_marker, il, sizeof(il), 0)) {
    p1 = dkstr_start(il, NULL);
    if(p1) {
      dkstr_chomp(p1, NULL);
      set_fold_markers(j, p1);
    }
  }
}



/**	Read configuration.
	@param	j	Jlayout job.
*/
void
jlconf_read DK_P1(JLJ *,j) {
  char *confname = NULL;
  size_t	conf_sz = 0;
  conf_sz = dksf_get_maxpathlen();
  if(conf_sz < 512) conf_sz = 512;
  if(conf_sz > 4096) conf_sz = 4096;
#ifdef MAXPATHLEN
  if(conf_sz > MAXPATHLEN) conf_sz = MAXPATHLEN;
#endif
  if(j->a) {
    configure_from_application(j);
  }
  confname = dk_new(char,conf_sz);
  if(confname) {
    if(dksf_get_home(confname, conf_sz)) {
      if((strlen(confname) + strlen(sep) + strlen(fn)) < conf_sz) {
        strcat(confname, sep);
	strcat(confname, fn);
	dksf_correct_fnsep(confname);
	read_config_file(j, confname);
      }
    }
    dk_delete(confname);
  }
  read_config_file(j, fn);
}


