/*
Copyright (c) 1998-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dktrace.c	The dktrace module.
*/

#include "dk.h"
#include <stdio.h>

#if DK_TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if DK_HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#if DK_HAVE_TIME_H
#include <time.h>
#endif
#endif
#endif



/**	Inside the dktrace module.
*/
#define DK_TRACE_C 1

#include "dktrace.h"



/**	Output file.
*/
static FILE *trace_file = NULL;

void  dktrace_end    DK_P0()
{
  if(trace_file) {
    fclose(trace_file); trace_file = NULL;
  }
}

void dk_trace_end DK_P0() { dktrace_end(); }

void  dktrace_init   DK_P1(char *,filename)
{
  FILE *x;
  if(filename) {
#if DK_HAVE_LARGEFILE64_SOURCE && DK_HAVE_FOPEN64
    x = fopen64(filename, "w");
#else
    x = fopen(filename, "w");
#endif
    if(x) {
      dktrace_end();
      trace_file = x;
    }
  }
}

void dk_trace_init DK_P1(char *, filename) { dktrace_init(filename); }


FILE *dktrace_file   DK_P0()
{
  return trace_file;
}

FILE *dk_trace_file DK_P0() { FILE *back; back = dktrace_file(); return back; }



/**	Write time to output file.
	@param	f	Output file.
*/
static
void i_time DK_P1(FILE *,f)
{
#if DK_HAVE_TIME_H || DK_HAVE_SYS_TIME_H
  time_t timer;
  struct tm *tm;
  if(f) {
    time(&timer);
    tm = localtime(&timer);
    if(tm) {
      fprintf(f,
	  "%04d/%02d/%02d %02d:%02d:%02d\n",
	  (1900 + tm->tm_year),
	  (1 + tm->tm_mon),
	  tm->tm_mday,
	  tm->tm_hour,
	  tm->tm_min,
	  tm->tm_sec
      );
    }
  }
#endif
}

void dktrace_time DK_P0()
{
  if(trace_file) {
    i_time(trace_file);
  }
}

void dktrace_stdout_time DK_P0()
{
  i_time(stdout);
}

void dk_trace_time DK_P0()
{
  dktrace_time();
}



