/*
Copyright (c) 2007-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dksdbdb.c	Simple database API for Berkeley DB.
*/



#include "dk.h"

#if DK_HAVE_STRING_H
#include <string.h>
#endif
#if DK_HAVE_FCNTL_H
#include <fcntl.h>
#endif
#if DK_HAVE_IO_H
#include <io.h>
#endif

#include "dkmem.h"
#include "dkstr.h"



/**	Inside the dksdbdb module.
*/
#define DKSDBI_BDB	1

#include "dksdbi.h"
#include "dksdbii.h"




#line 71 "dksdbdb.ctr"




#if DK_HAVE_DB_H


#include <db.h>



int
dksdbi_bdb_close DK_P1(dk_sdbi_db *,p)
{
  int back = 0;
  DB *db;
  
  db = (DB *)(p->dbptr);
  if(db) {
    db->close(db, 0);
    p->dbptr = NULL;
    back = 1;
  }
  
  return back;
}



int
dksdbi_bdb_open DK_P1(dk_sdbi_db *,p)
{
  int back = 0, ret = 0;
  DB *db;
  u_int32_t flags = 0;
  
  flags = DB_CREATE;
  if((p->acc) & DK_SDBI_MODE_WRITE) {		
    if((p->acc) & DK_SDBI_MODE_TRUNCATE) {	
      flags |= DB_TRUNCATE;
    }
  } else {					
    flags |= DB_RDONLY;
  }
  db = NULL;
  if(db_create(&db, NULL, 0) == 0) {		
    ret = db->open(
      db,
      NULL,
      p->fn,
      NULL,
      DB_BTREE,
      flags,
      p->tfm
    );
    if(ret == 0) {				
      back = 1;
      p->dbptr = (void *)db;
    } else {					
      db->close(db, 0); db = NULL;
    }
  } else {					
  }
  
  return back;
}



int
dksdbi_bdb_store DK_P6(dk_sdbi_db *,p, void *,kp, size_t,kl, void *,vp, size_t,vl, int,insm)
{
  int back = 0;
  DB *db;
  
  db = (DB *)(p->dbptr);
  if(db) {
    DBT k, v; int ret; u_int32_t flags;
    DK_MEMRES(&k,sizeof(DBT)) ; DK_MEMRES(&v,sizeof(DBT)) ; flags = 0;
    if(insm & DK_SDBI_INSMOD_NO_REPLACE) {
      flags = DB_NOOVERWRITE;
    } else {
      k.data = kp; k.size = kl;
      db->del(db, NULL, &k, 0);
      DK_MEMRES(&k,sizeof(DBT)) ;
    }
    k.data = kp; k.size = kl; v.data = vp; v.size = vl;
    ret = db->put(db, NULL, &k, &v, flags);
    if(ret == 0) { back = 1; }
  }
  
  return back;
}



int
dksdbi_bdb_delete DK_P3(dk_sdbi_db *,p, char *,kp, size_t,kl)
{
  int back = 0;
  DB *db;
  DBT k; int ret;
  
  db = (DB *)(p->dbptr);
  if(db) {
    DK_MEMRES(&k,sizeof(DBT)) ;
    k.data = kp; k.size = kl;
    ret = db->del(db, NULL, &k, 0);
    if(ret == 0) { back = 1; }
  }
  
  return back;
}



int
dksdbi_bdb_fetch DK_P5(dk_sdbi_db *,p, void *,kp, size_t,kl, void *,vp, size_t *,vl)
{
  int back = 0;
  DB *db;
  DBT k, v; int ret;
  
  db = (DB *)(p->dbptr);
  if(db) {
    DK_MEMRES(&k,sizeof(DBT)) ;
    DK_MEMRES(&v,sizeof(DBT)) ;
    k.data = kp; k.size = kl;
    ret = db->get(db, NULL, &k, &v, 0);
    if(ret == 0) {
      if(v.size <= (*vl)) {
        DK_MEMCPY(vp,v.data,v.size) ;
	*vl = v.size;
	back = 1;
      } else {
        DK_MEMCPY(vp,v.data,(*vl)) ;
	back = -1;
      }
    } else {
    }
  }
  
  return back;
}



int
dksdbi_bdb_string_fetch  DK_P4(dk_sdbi_db *,p, char *,kp, char *,vp, size_t,s)
{
  int back = 0;
  DB *db;
  DBT k, v; int ret;
  
  db = (DB *)(p->dbptr);
  if(db) {
    DK_MEMRES(&k,sizeof(DBT)) ; DK_MEMRES(&v,sizeof(DBT)) ;
    k.data = kp; k.size = (1+strlen(kp));
    ret = db->get(db, NULL, &k, &v, 0);
    if(ret == 0) {
      if(v.size < s ) {
        DK_MEMCPY(vp,v.data,v.size) ;
	vp[v.size] = '\0';
	back = 1;
      } else {
        DK_MEMCPY(vp,v.data,(s-1)) ;
	vp[s-1] = '\0';
	back = -1;
      }
    } else {		
    }
  }
  
  return back;
}



int
dksdbi_bdb_traverse DK_P3(dk_sdbi_db *,p, void *,d, dk_sdbi_fct_t *,f)
{
  int back = 0;
  DB *db;
  DBT k, v; int ret;
  DBC *cursorp = NULL;
  int cc = 0;
  
  db = (DB *)(p->dbptr);
  if(db) {
    DK_MEMRES(&k,sizeof(DBT)) ; DK_MEMRES(&v,sizeof(DBT)) ;
    ret = db->cursor(db, NULL, &cursorp, 0);
    if(ret == 0) {
      if(cursorp) {
        ret = cursorp->c_get(cursorp, &k, &v, DB_FIRST);
	if(ret == 0) {
	  switch((*f)(d, k.data, k.size, v.data, v.size)) {
	    case 0: case 1: { cc = 1; back = 1; } break;
	    default: { cc = 0; } break;
	  }
	  while(cc) {
	    DK_MEMRES(&k,sizeof(DBT)) ; DK_MEMRES(&v,sizeof(DBT)) ;
	    ret = cursorp->c_get(cursorp, &k, &v, DB_NEXT);
	    if(ret == 0) {
	      switch((*f)(d, k.data, k.size, v.data, v.size)) {
	        case -1: { cc = 0; } break;
	      }
	    } else {
	      cc = 0;
	      if(ret != DB_NOTFOUND) {
	        back = 0;
	      }
	    }
	  }
	} else {
	}
      }
    } else {
    }
    if(cursorp) {
      cursorp->c_close(cursorp);
      cursorp = NULL;
    }
  }
  
  return back;
}



int
dksdbi_bdb_sync DK_P1(dk_sdbi_db *,p)
{
  int back = 0, ret = 0;
  DB *db;
  
  db = (DB *)(p->dbptr);
  if(db) {
    ret = db->sync(db, 0);
    if(ret == 0) { back = 1; }
  }
  
  return back;
}



#endif


