/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dkpwd.c	The dkpwd program.
*/



#include <dk.h>

#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK_HAVE_PROCESS_H
#include <process.h>
#endif
#if DK_HAVE_STRING_H
#include <string.h>
#endif

#include <dksf.h>
#include <dkstr.h>


/**	Buffer for current working directory, large enough I hope.
*/
static char buffer[4096];


/**	Exit status code.
*/
static int exval = 0;



/**	Beautify the directory (convert to lower case, backslashes to slashes).
	@param	buffer	Buffer containing the current directory.
*/
static void beautify DK_P1(char *, buffer)
{
#if DK_HAVE_FEATURE_BACKSLASH || DK_HAVE_FEATURE_BACKSLASH
  char *ptr;
  ptr = buffer;
  while(*ptr) {
#if DK_HAVE_FNCASEINS
    if((*ptr >= 'A') && (*ptr <= 'Z')) {
      *ptr = *ptr - 'A' + 'a';
    }
#endif
#if DK_HAVE_FEATURE_BACKSLASH
    if(*ptr == '\\') {
      *ptr = '/'; 
    }
#endif
    ptr++;
  }
#endif
}



/**	Check whether or not we should deliver the directory for using in
	a prompt string.
	@return	1=yes, 0=no.
*/
static int
must_prompt DK_P0()
{
  char *ptr;
  int back = 0;
  ptr = getenv("DKPWD_PROMPT");
  if(ptr) {
    if(dkstr_is_on(ptr)) {
      back = 1;
    }
  }
  return back;
}



/**	Check whether or not we must beautify (backslash-to-slash conversion)
	the result.
	@return	1=yes, 0=no.
*/
static int
must_beautify DK_P0()
{
  char *ptr;
  int back = 0;
  ptr = getenv("DKPWD_BEAUTIFY");
  if(ptr) {
    if(dkstr_is_on(ptr)) {
      back = 1;
    }
  }
  return back;
}



/**	The main() function of the dkpwd program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
int main(int argc, char *argv[])
{
  int i, mbeau, pro;
  char *ptr, **lfdptr;
  mbeau = 0; pro = 0;
  if(dksf_getcwd(buffer,sizeof(buffer))) {
    exval = 1;
    lfdptr = argv; lfdptr++; i = 1;
    while(i < argc) {
      ptr = *lfdptr;
      while(*ptr) {
        switch(*ptr) {
	  case 'b' : {
	    mbeau = 1;
	  } break;
	  case 'p' : {
	    pro = 1;
	  } break;
	}
        ptr++;
      }
      i++; lfdptr++;
    }
    if(mbeau || must_beautify()) {
      beautify(buffer);
    }
    printf("%s", buffer);
    if(!(pro || must_prompt())) {
      printf("\n");
    }
  }
  exval = (exval ? 0 : 1); exit(exval); return exval;
}


