/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	dkerror.h
	Error constants.
	This file contains definitions for error codes.
*/

#ifndef DK_ERROR_INC

/** Make sure to include the file only once. */
#define DK_ERROR_INC 1

/** No error. No error occured, the operation was finished successfully. */
#define DK_ERR_NONE			0

/** System error. A system error occured, see errno. */
#define DK_ERR_SYSERR			1

/** Memory error. Not enough memory (RAM/swap space) available. */
#define DK_ERR_NOMEM			2

/** Buffer too small. The buffer length is no sufficient. */
#define DK_ERR_BUFFER_LENGTH		3

/** Out of range. The result of a mathematical operation is outside the
range of a data type. */
#define DK_ERR_MATH_OOR			4

/** Zero division. Mathematical error, division by 0. */
#define DK_ERR_DIV_ZERO			5

/** gethostbyname() not available. The gethostbyname() function is not
available. */
#define DK_ERR_NO_GETHOSTBYNAME		6

/** No such host. No information was found about the given host name. */
#define DK_ERR_NO_SUCH_HOST		7

/** Try again later. A resource is temporarily unavailable. */
#define DK_ERR_TRY_AGAIN		8

/** Failed. An operation failed. Do not attempt to repeat the operation. */
#define DK_ERR_NO_RECOVERY		9

/** No DNS response. There was no response from the DNS server. */
#define DK_ERR_NO_DNS_RESPONSE		10

/** Unknown error. No detailed information is available. */
#define DK_ERR_UNKNOWN_ERROR		11

/** Invalid arguments. The arguments provided to a function can not be used. */
#define DK_ERR_INVALID_ARGS		12

/** No host name. Failed to obtain the system's own host name. */
#define DK_ERR_GETHOSTNAME_FAILED	13

/** Not now. The operation can not be performed at this time. */
#define DK_ERR_NOT_NOW			14

/** Invlid file handle. The argument is not a valid file handle. */
#define DK_ERR_INVALID_FILEHANDLE	15

/** Connection closed by peer. A network connection was closed by the peer. */
#define DK_ERR_CONNECTION_CLOSED_BY_PEER 16

/** Interrupted. An interrupt occured while performing the operation. */
#define DK_ERR_INTERRUPTED		17

/** Out of band data. Out of band data is of higher priority than normal data.
*/
#define DK_ERR_NO_OOB_DATA		18

/** Not connected. A connection must be established before sending or
receiving data. */
#define DK_ERR_NOT_CONNECTED		19

/** Time out. A timeout occured while waiting for the operation to complete. */
#define DK_ERR_TIMED_OUT		20

/** I/O error. An I/O error occured. */
#define DK_ERR_IO			21

/** Resources problem. Insufficient resources available. */
#define DK_ERR_RESOURCES		22

/** Address family not supported. No support for the specified address
family available. */
#define DK_ERR_AF_NO_SUPPORT		23

/** Message too large. Messages must not exceed a certain size. */
#define DK_ERR_MSG_SIZE			24

/** Pipe error. No one is reading from the pipe. */
#define DK_ERR_PIPE			25

/** Address needed. The operation needs an address. */ 
#define DK_ERR_NEED_ADDR		26

/** Host unreachable. The host can not be reached at this time. */
#define DK_ERR_HOST_UNREACHABLE		27

/** Interface down. The network interface is down. */
#define DK_ERR_NET_INTERFACE_DOWN	28

/** Network unreachable. The network is (temporarily) unreachable. */
#define DK_ERR_NET_UNREACHABLE		29

/** Access permissions problem. An operation failed do to insufficient
permissions. */
#define DK_ERR_ACCESS			30

/** Protocol not supported. The specified protocol is not supported on this
system. */
#define DK_ERR_PROTO_NOT_SUPPORTED	31

/** Address in use. The address is currently in use. */
#define DK_ERR_ADDRESS_IN_USE		32

/** Address not available. The address is currently not available. */
#define DK_ERR_ADDRESS_NOT_AVAILABLE	33

/** Already connected. The network transport endpoint is connected. */
#define DK_ERR_ALREADY_CONNECTED	34

/** Connect in progress. A connect operation is in progress. */
#define DK_ERR_CONNECT_IN_PROGRESS	35

/** Connection refused by peer. Failed to connect to the specified peer. */
#define DK_ERR_CONNECTION_REFUSED_BY_PEER	36

/** Busy. A resource is busy. */
#define DK_ERR_BUSY			37

/** String too long. A specified string is too long for internal buffers. */
#define DK_ERR_STRING_TOO_LONG		38

/** No such file. An invalid file name or file pattern was specified. */
#define DK_ERR_NO_SUCH_FILE		39

/** Not unique. A pattern does not match exactly one file name. */
#define DK_ERR_NOT_UNIQUE		40

/** Finished. Finished to traverse a collection. */
#define DK_ERR_FINISHED			41

/** Function unsupported. The requested functionality is not supported. */
#define DK_ERR_FUNCTION_UNSUPPORTED	42

/** Syntax error. There was a syntax error in input data. */
#define DK_ERR_SYNTAX			43

/** No such object. The requested object can not be found. */
#define DK_ERR_NO_SUCH_OBJECT		44

#endif



