/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file dkcp.h	Codepage handling.
	A codepage is a table of 256 unsigned bytes used for
	byte replacements.
	On Windows systems the same text
	when printed to command prompt box looks differently than
	printed to file and viewed in a text editor.
	We can get both texts look equally applying codepage replacements
	before printing the texts.
*/
#ifndef DK_CP_INCLUDED
#define DK_CP_INCLUDED 1

#include <dk.h>
#include <dktypes.h>

#if defined(EXTERN)
#undef EXTERN
#endif
#ifndef DK_CP_C
#if !DK_HAVE_PROTOTYPES
#define EXTERN extern
#else
#define EXTERN /* nix */
#endif
#else
#define EXTERN /* nix */
#endif

#if defined(__cplusplus)
extern "C" {
#endif



/**	Open codepage structure, read data from stream.
	The codepage structure is created in dynamically allocated memory,
	use dk_delete() to release the memory.
	@param	s	Stream to read codepage from.
	@return	Pointer to codepage structure on success, NULL on error.
*/
EXTERN unsigned char *
dkcp_open DK_PR((dk_stream_t *s));



/**	Convert one character.
	@param	p	Pointer to the codepage structure.
	@param	c	Character to convert.
	@return	The converted character.
*/
EXTERN unsigned char
dkcp_convert DK_PR((unsigned char *p, unsigned char c));



/**	Write string to file, do codepage conversions if necessary.
	@param	o	Output file.
	@param	p	Pointer to codepage structure.
	@param	s	String to write.
*/
EXTERN void
dkcp_fputs DK_PR((FILE *o, unsigned char *p, char *s));



#if defined(__cplusplus)
}
#endif

#endif
/* DK_CP_INCLUDED */

