/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dkcp.c	Codepage support module.
*/



#include "dk.h"
#include "dktypes.h"
#include "dkmem.h"
#include "dkstream.h"
#include "dkstr.h"



/**	Inside the dkcp module.
*/
#define DK_CP_C 1

#include "dkcp.h"

#include <stdio.h>




#line 63 "dkcp.ctr"




/**	Abbreviation.
*/
typedef unsigned char UCHAR;



unsigned char *
dkcp_open DK_P1(dk_stream_t *,st)
{
  unsigned char *back = NULL;
#if DK_HAVE_CODEPAGES
  unsigned index, i1, i2;
  unsigned char uc;
  int can_continue;
  char input_line[256];
  char s1[sizeof(input_line)], s2[sizeof(input_line)];
  char *cptr;

  if(st) {
    back = dk_new(UCHAR,256);
    if(back) {
      for(index = 0; index < 256; index++) {
	uc = index;
	back[index] = uc;
      }
      can_continue = 1;
      while(can_continue) {
	if(dkstream_gets(st, input_line, sizeof(input_line))) {
	  cptr = dkstr_chr(input_line, '#');
	  if(cptr) *cptr = '\0';
	  if(sscanf(input_line, "%s %s", s1, s2) == 2) {
	    if(sscanf(s1, "%u", &i1) == 1) {
	      if(i1 > 255) i1 = i1 & 0xFF;
	      if(sscanf(s2, "%u", &i2) == 1) {
		if(i2 > 255) i2 = i2 & 0xFF;
		uc = i2;
		back[i1] = uc;
	      } else {
		if(strcmp(s2, "-") == 0) {
		  back[i1] = ' ';
		}
	      }
	    }
	  }
	} else {
	  can_continue = 0;
	}
      }
    }
  }
#endif
  return back;
}



unsigned char
dkcp_convert DK_P2(unsigned char *, codepage, unsigned char, c)
{
  unsigned char back;
#if DK_HAVE_CODEPAGES
  unsigned index;
  if(codepage) {
    index = c;
    if(index > 255)  index = 255;
    back = codepage[index];
  } else {
    back = c;
  }
#else
  back = c;
#endif
  return back;
}



void
dkcp_fputs DK_P3(FILE *, out, unsigned char *, cp, char *, str)
{
  if(out && str) {
    if(cp) {
#if DK_HAVE_CODEPAGES
      char c, *cptr;
      cptr = str;
      while(*cptr) {
	c = (char)dkcp_convert(cp, (unsigned char)(*cptr));
	fputc(c, out);
	cptr++;
      }
#else
      fputs(str, out);
#endif
    } else {
      fputs(str, out);
    }
  }
}


