/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dkbifpbm.c	PBM support module for dkbif.
*/



/**	Inside the dkbifpbm module.
*/
#define DKBIFPBM_C	1

#include "dkbifi.h"
#include "dkbif.h"




#line 54 "dkbifpbm.ctr"




#if DK_HAVE_PNM_H || DK_HAVE_NETPBM_PNM_H



/**	Program name, used for diagnostic messages.
*/
static char program_name[] = { "bmeps" };



/**	Configure the dkbifpbm module.
*/
static
void
do_configure DK_P0()
{
  static char must_configure = 0x01;
  char *argv[2];
  int pnm_argc;
  if(must_configure) {
    must_configure = 0x00;
    argv[0] = program_name;
    argv[1] = NULL;
    pnm_argc = 1;
    pnm_init(&pnm_argc, argv);
  }
}



static
void
init_pbm_frame DK_P2(dk_bif_t *,p, dk_bif_frame_t *,f)
{
  
  f->xdpi = -1.0; f->ydpi = -1.0;
  f->mr = f->mg = f->mb = 1.0;
  
}



int
dkbifpbm_header DK_P2(dk_bif_t *,p, FILE *,f)
{
  int back = 0;
  int rows = 0, cols = 0, format = 0;
  xel **array = NULL; xelval maxxelval = 0;
  
  if((p) && (f)) {
    do_configure();
    array = pnm_readpnm(f,&cols,&rows,&maxxelval,&format);
    if((array) && (rows > 0) && (cols > 0)) {
      p->cf = dkbif_frame_new(p, 0UL);
      if(p->cf) {
        p->nof = 1UL;
        init_pbm_frame(p, p->cf);
	((p->cf)->d).pnm.rows = rows;
	((p->cf)->d).pnm.cols = cols;
	((p->cf)->d).pnm.format = format;
	((p->cf)->d).pnm.array = array;
	((p->cf)->d).pnm.maxxelval = maxxelval;
	((p->cf)->d).pnm.maxxeldbl = dkma_ul_to_double((unsigned long)maxxelval);
	back = 1;	/* yippieh, reading PNMs is really easy */
        (p->cf)->w = (unsigned long)cols;
	(p->cf)->h = (unsigned long)rows;
	(p->cf)->ch = ((PNM_FORMAT_TYPE(format) == PPM_TYPE) ? 3 : 1);
	(p->cf)->bpc = 8;
	(p->cf)->vmask = dkbif_max_for_bpc((p->cf)->bpc);
	(p->cf)->vmax = dkma_ul_to_double((p->cf)->vmask);
      } else {
        pnm_freearray(array, rows);
      }
    } else {
      if(array) {
        pnm_freearray(array, rows);
      }
    }
  }
  
  return back;
}



int
dkbifpbm_data DK_P2(dk_bif_t *,p, FILE *,f)
{
  int back = 0;
  
  if(p->cf) {
    if(((p->cf)->d).pnm.array) {
      back = 1;		/* data was already read */
    }
  }
  
  return back;
}



unsigned short
dkbifpbm_red DK_P3(dk_bif_t *,p, unsigned long,x, unsigned long,y)
{
  unsigned short back = 255;
  
  if(p) {
    if(p->cf) {
      if((p->cf)->ch == 3) {
        back = PPM_GETR( ( ( ((p->cf)->d).pnm.array)[y] )[x] );
      } else {
        back = PNM_GET1( ( ( ((p->cf)->d).pnm.array)[y] )[x] );
      }
    }
  }
  if(((p->cf)->d).pnm.maxxelval != 255) {
    int me = 0;
    back = (unsigned short)dkma_double_to_ul_ok(
      dkma_div_double_ok(
        dkma_mul_double_ok(
	dkma_ul_to_double(
	  (unsigned long)back),
	  255.0,
	  &me
	),
	((p->cf)->d).pnm.maxxeldbl,
	&me
      ),
      &me
    );
    if(me) { p->ec = DK_ERR_MATH_OOR; }
  }
  
  return back;
}



unsigned short
dkbifpbm_green DK_P3(dk_bif_t *,p, unsigned long,x, unsigned long,y)
{
  unsigned short back = 255;
  
  if(p) {
    if(p->cf) {
      if((p->cf)->ch == 3) {
        back = PPM_GETG( ( ( ((p->cf)->d).pnm.array)[y] )[x] );
      } else {
        back = PNM_GET1( ( ( ((p->cf)->d).pnm.array)[y] )[x] );
      }
    }
  }
  if(((p->cf)->d).pnm.maxxelval != 255) {
    int me = 0;
    back = (unsigned short)dkma_double_to_ul_ok(
      dkma_div_double_ok(
        dkma_mul_double_ok(
	dkma_ul_to_double(
	  (unsigned long)back),
	  255.0,
	  &me
	),
	((p->cf)->d).pnm.maxxeldbl,
	&me
      ),
      &me
    );
    if(me) { p->ec = DK_ERR_MATH_OOR; }
  }
  
  return back;
}



unsigned short
dkbifpbm_blue DK_P3(dk_bif_t *,p, unsigned long,x, unsigned long,y)
{
  unsigned short back = 255;
  
  if(p) {
    if(p->cf) {
      if((p->cf)->ch == 3) {
        back = PPM_GETB( ( ( ((p->cf)->d).pnm.array)[y] )[x] );
      } else {
        back = PNM_GET1( ( ( ((p->cf)->d).pnm.array)[y] )[x] );
      }
    }
  }
  if(((p->cf)->d).pnm.maxxelval != 255) {
    int me = 0;
    back = (unsigned short)dkma_double_to_ul_ok(
      dkma_div_double_ok(
        dkma_mul_double_ok(
	dkma_ul_to_double(
	  (unsigned long)back),
	  255.0,
	  &me
	),
	((p->cf)->d).pnm.maxxeldbl,
	&me
      ),
      &me
    );
    if(me) { p->ec = DK_ERR_MATH_OOR; }
  }
  
  return back;
}



unsigned short
dkbifpbm_gray DK_P3(dk_bif_t *,p, unsigned long,x, unsigned long,y)
{
  unsigned short back = 255;
  int me = 0;
  
  if(p) {
    if(p->cf) {
      if((p->cf)->ch == 1) {
        back = PNM_GET1( ( ( ((p->cf)->d).pnm.array)[y] )[x] );
        if(((p->cf)->d).pnm.maxxelval != 255) {
          int me = 0;
          back = (unsigned short)dkma_double_to_ul_ok(
            dkma_div_double_ok(
              dkma_mul_double_ok(
	      dkma_ul_to_double(
	        (unsigned long)back),
	        255.0,
	        &me
	      ),
	      ((p->cf)->d).pnm.maxxeldbl,
	      &me
            ),
            &me
          );
          if(me) { p->ec = DK_ERR_MATH_OOR; }
        }
      } else {
        unsigned short r = 0, g = 0, b = 0;
	r = dkbifpbm_red(p, x, y);
	g = dkbifpbm_green(p, x, y);
	b = dkbifpbm_blue(p, x, y);
	if(p->fntsc) {
	  back = (unsigned short)(
	    (
	      dkma_add_ulong_ok(
		dkma_add_ulong_ok(
		  dkma_mul_ulong_ok(54UL,(unsigned long)r,&me),
		  dkma_mul_ulong_ok(183UL,(unsigned long)g,&me),
		  &me
		),
		dkma_mul_ulong_ok(19UL,(unsigned long)b,&me),
		&me
	      ) >> 8
	    ) & 0xFFFF
	  );
	} else {
	  back = (unsigned short)dkma_double_to_ul_ok(
	    dkma_rint(
	      dkma_add_double_ok(
	  	dkma_add_double_ok(
		  dkma_mul_double_ok(
		    0.3,dkma_ul_to_double((unsigned long)r),&me
		  ),
		  dkma_mul_double_ok(
		    0.59,dkma_ul_to_double((unsigned long)g),&me
		  ),
		  &me
		),
		dkma_mul_double_ok(
		  0.11,dkma_ul_to_double((unsigned long)g),&me
		),
		&me
	      )
	    ),
	    &me
	  );
	}
	if(me) { p->ec = DK_ERR_MATH_OOR; }
      }
    }
  }
  
  return back;
}



unsigned short
dkbifpbm_alpha DK_P3(dk_bif_t *,p, unsigned long,x, unsigned long,y)
{
  unsigned short back = 255;
  
  
  return back;
}



void
dkbifpbm_frame_release DK_P2(dk_bif_t *,p, dk_bif_frame_t *,f)
{
  
  if((f->d).pnm.array) {
    pnm_freearray((f->d).pnm.array, (f->d).pnm.rows);
  }
  
}



void
dkbifpbm_release DK_P1(dk_bif_t *,p)
{
  
  
}



#endif


