/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	addctrld.c	Ensure to have CTRL-D as last byte.

This program is a filter. If the last byte in the input stream
is not a CTRL-D the program appends a CTRL-D.
*/

#include <dk.h>


#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#if DK_HAVE_STDIO_H
#include <stdio.h>
#endif
#if DK_HAVE_IO_H
#include <io.h>
#endif
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif



#line 64 "addctrld.ctr"




#if !DK_HAVE_SSIZE_T
#ifdef DK_HAVE_SSIZE_T
#undef DK_HAVE_SSIZE_T
#endif
/**	Data type for read/write operation result.
*/
typedef size_t ssize_t;

/**	Flag: ssize_t defined.
*/
#define DK_HAVE_SSIZE_T 1
#endif



/**	Length of output buffer in bytes.
*/
#define BUFFER_SIZE 4096


/**	Output buffer.
*/
static char outbuffer[BUFFER_SIZE];


/**	Number of bytes currently used in output buffer.
*/
static size_t outbused;



/**	Flush output buffer.
*/
static void flush_buffer(void)
{
  if(outbused > 0) {
#if DK_HAVE_WRITE
    (void)write(1, (void *)outbuffer, outbused);
#else
#if DK_HAVE__WRITE
    (void)_write(1, (void *)outbuffer, outbused);
#else

#endif
#endif
  }
  outbused = 0;
}


/**	Add one character to output buffer, flush if buffer is full.
	@param	c	Character to add.
*/
static void add_char(char c)
{
  outbuffer[outbused++] = c;
  if(outbused == sizeof(outbuffer)) {
    flush_buffer();
    outbused = 0;
  }
}



/**	The main() function of the addctrld program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, other values indicate errors.
*/
int main(int argc, char *argv[])
{
  char inbuffer[sizeof(outbuffer)];
  char *ptr;
  int ende; ssize_t lgt; int have_ctrld;

  outbused = 0; ende = 0; have_ctrld = 0;
  while(ende == 0) {
#if DK_HAVE_READ
    lgt = read(0, inbuffer, sizeof(inbuffer));
#else
#if DK_HAVE__READ
    lgt = _read(0, inbuffer, sizeof(inbuffer)); 
#else
    lgt = 0;
#endif
#endif
    if(lgt > 0) {
      ptr = inbuffer;
      while(lgt--) {
	if(*ptr == 0x04) have_ctrld = 1;
	else             have_ctrld = 0;
	add_char(*(ptr++));
      }
    } else {
      ende = 1;
    }
  }
  if(!have_ctrld) add_char(0x04);
  flush_buffer();
  exit(0); return 0;
}


