/* $Id: TestSquare.java,v 1.5 2000/07/28 20:06:11 gelderen Exp $
 *
 * Copyright (C) 1995-1999 The Cryptix Foundation Limited.
 * All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library;
 * if not, you can download a copy from http://www.cryptix.org/ .
 */
package cryptix.jce.test;


final class TestSquare
extends CipherTest
{
    private static final String NAME="Square";

    private static final String[][] TEST_VALUES =
    {
        {"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F"},
        {"000102030405060708090a0b0c0d0e0f", "000102030405060708090a0b0c0d0e0f000102030405060708090a0b0c0d0e0f", "7C3491D94994E70F0EC2E7A5CCB5A14F7C3491D94994E70F0EC2E7A5CCB5A14F"},
        {"80000000000000000000000000000000", "00000000000000000000000000000000", "05f8aafdefb4f5f9c751e5b36c8a37d8"},
        {"40000000000000000000000000000000", "00000000000000000000000000000000", "60affc9b2312b1397177251cc9296391"},
        {"20000000000000000000000000000000", "00000000000000000000000000000000", "d67b7e07c38f311446e16ddd9ea96ebe"},
        {"10000000000000000000000000000000", "00000000000000000000000000000000", "39207579067031706fab8c3a5c6e5524"},
        {"08000000000000000000000000000000", "00000000000000000000000000000000", "fc4f2602a3f6ac34f56906c2eeee40c5"},
        {"04000000000000000000000000000000", "00000000000000000000000000000000", "6f2431469f4a0866632216c59c18ff11"},
        {"02000000000000000000000000000000", "00000000000000000000000000000000", "c745f6f339d1bb9524e1b2d2b0dde843"},
        {"01000000000000000000000000000000", "00000000000000000000000000000000", "241e113a1bb5c32cc45d95d7734165aa"},
        {"00800000000000000000000000000000", "00000000000000000000000000000000", "5e16777211c67ae4609f6a47bf5df2c4"},
        {"00400000000000000000000000000000", "00000000000000000000000000000000", "272330139236c300cd161f0266b62494"},
        {"00200000000000000000000000000000", "00000000000000000000000000000000", "15115b9e29524325e7c992ead262ade8"},
        {"00100000000000000000000000000000", "00000000000000000000000000000000", "acdcce277b801ed53dfe0fc12f4c957b"},
        {"00080000000000000000000000000000", "00000000000000000000000000000000", "9cadb290cedd6f7ca6c10d42fe4c1a70"},
        {"00040000000000000000000000000000", "00000000000000000000000000000000", "d70d4c24ffbf3de6e6bd54ec03b8492a"},
        {"00020000000000000000000000000000", "00000000000000000000000000000000", "602455a418a99a942fed27123b9f73e6"},
        {"00010000000000000000000000000000", "00000000000000000000000000000000", "f239c4efd3729d43081544104378f0ea"},
        {"00008000000000000000000000000000", "00000000000000000000000000000000", "70259a9572990099ac563114074db3d2"},
        {"00004000000000000000000000000000", "00000000000000000000000000000000", "932d3644863b6377100c64f243445e7e"},
        {"00002000000000000000000000000000", "00000000000000000000000000000000", "47100bf12f2e1f718e9430f4127535be"},
        {"00001000000000000000000000000000", "00000000000000000000000000000000", "2ed60ffa71c162a53c3a8bba2b0b042b"},
        {"00000800000000000000000000000000", "00000000000000000000000000000000", "e2992d6bdc7c65b70b62685c0d84425c"},
        {"00000400000000000000000000000000", "00000000000000000000000000000000", "c552ca3d805e456f5239dd7956cacd71"},
        {"00000200000000000000000000000000", "00000000000000000000000000000000", "95b577c2ed3c2d9d96c2106e091b1f72"},
        {"00000100000000000000000000000000", "00000000000000000000000000000000", "3d550ae470bfb0306c3099c8d5a471d8"},
        {"00000080000000000000000000000000", "00000000000000000000000000000000", "fc13974afe73a92598aa95edcb2102e9"},
        {"00000040000000000000000000000000", "00000000000000000000000000000000", "ab0cf3a0cfef3aa3d10738523e624a1d"},
        {"00000020000000000000000000000000", "00000000000000000000000000000000", "72fea53144f673e283547f08da30bdda"},
        {"00000010000000000000000000000000", "00000000000000000000000000000000", "389fef99fa1a3dbf664673aa39d848d1"},
        {"00000008000000000000000000000000", "00000000000000000000000000000000", "041152bca8440e8de572dce9dcc88cdc"},
        {"00000004000000000000000000000000", "00000000000000000000000000000000", "845b37c1338a0ba0f295be273841b940"},
        {"00000002000000000000000000000000", "00000000000000000000000000000000", "e2e3a1c7998040ee6bd8714e65ebd8af"},
        {"00000001000000000000000000000000", "00000000000000000000000000000000", "0b2b34c480648dc91f938dd368464780"},
        {"00000000800000000000000000000000", "00000000000000000000000000000000", "96bad4a54376917044b1076727a91e2b"},
        {"00000000400000000000000000000000", "00000000000000000000000000000000", "dd8c3dff69c3fda2802dffcdef1b1631"},
        {"00000000200000000000000000000000", "00000000000000000000000000000000", "da45872e48af2f0ec7fc395d03ff9451"},
        {"00000000100000000000000000000000", "00000000000000000000000000000000", "b25194c0f1953f35bc4c0871cd2d4a40"},
        {"00000000080000000000000000000000", "00000000000000000000000000000000", "3e09af82736971f2847834082d6ec6f3"},
        {"00000000040000000000000000000000", "00000000000000000000000000000000", "fa75a64f778b914dc4b926626bc8b4c0"},
        {"00000000020000000000000000000000", "00000000000000000000000000000000", "d21542857f03f6a92cacd2e783e33e3e"},
        {"00000000010000000000000000000000", "00000000000000000000000000000000", "1ec0a5b9781c5e90b1e15731e0625c36"},
        {"00000000008000000000000000000000", "00000000000000000000000000000000", "e1c58917e586b6c46c46982fa303f14c"},
        {"00000000004000000000000000000000", "00000000000000000000000000000000", "72ecc0d267b445482924c9969de97a15"},
        {"00000000002000000000000000000000", "00000000000000000000000000000000", "a52af631193375dd59555e2753acde65"},
        {"00000000001000000000000000000000", "00000000000000000000000000000000", "033b8482c4010eb20a3edd4ba35a3db7"},
        {"00000000000800000000000000000000", "00000000000000000000000000000000", "56534a944796abdf51ad247b8c9ee9bb"},
        {"00000000000400000000000000000000", "00000000000000000000000000000000", "9eda6fd2cd4eabf8218b98a165e82b9e"},
        {"00000000000200000000000000000000", "00000000000000000000000000000000", "60043a7e110e1321bc41e4ac47d1f45e"},
        {"00000000000100000000000000000000", "00000000000000000000000000000000", "90e685c8f990cedeacc8a2bfc8e46ca2"},
        {"00000000000080000000000000000000", "00000000000000000000000000000000", "b9e77e32f721c0a7a02b50925311e834"},
        {"00000000000040000000000000000000", "00000000000000000000000000000000", "001d2fe95bb39ef0c3548307ea7580f3"},
        {"00000000000020000000000000000000", "00000000000000000000000000000000", "a5dd651290a063f4e7c5e714c9c398b4"},
        {"00000000000010000000000000000000", "00000000000000000000000000000000", "aa7b3b9f459ba0367ff2a332ef725da1"},
        {"00000000000008000000000000000000", "00000000000000000000000000000000", "a424f80b0048756879ed6343768bbe08"},
        {"00000000000004000000000000000000", "00000000000000000000000000000000", "ea4590786de7f8a68439b4616bf7e4b9"},
        {"00000000000002000000000000000000", "00000000000000000000000000000000", "7d15058fe884dcf0976105a816cf6366"},
        {"00000000000001000000000000000000", "00000000000000000000000000000000", "a07d1b74ae6a3f26a8a25e1e778a0d4a"},
        {"00000000000000800000000000000000", "00000000000000000000000000000000", "61f13db32828961c3e35d9b7ab77b57d"},
        {"00000000000000400000000000000000", "00000000000000000000000000000000", "0e2979112efb29754605011a358093fc"},
        {"00000000000000200000000000000000", "00000000000000000000000000000000", "a878c8a8a5230917c56f7eb74fdada25"},
        {"00000000000000100000000000000000", "00000000000000000000000000000000", "34343f73232790e6fa44d8f606a24de9"},
        {"00000000000000080000000000000000", "00000000000000000000000000000000", "d569b991761c26dde723cca0c262f195"},
        {"00000000000000040000000000000000", "00000000000000000000000000000000", "f1a0f35ada018c5df56ffe0dc95636bf"},
        {"00000000000000020000000000000000", "00000000000000000000000000000000", "b26af455039312e1206290a921459e1a"},
        {"00000000000000010000000000000000", "00000000000000000000000000000000", "594049c7e3a34e1b9bccefaf5e75b373"},
        {"00000000000000008000000000000000", "00000000000000000000000000000000", "4e4e037f07ff26e8e9065f26afedaf2d"},
        {"00000000000000004000000000000000", "00000000000000000000000000000000", "ddedc3ca10ec011ea24dd4566d21409c"},
        {"00000000000000002000000000000000", "00000000000000000000000000000000", "3660f51bb790f275a55aa435db6da193"},
        {"00000000000000001000000000000000", "00000000000000000000000000000000", "a9a7cfe07ea640498e832ae25e2906ed"},
        {"00000000000000000800000000000000", "00000000000000000000000000000000", "3863d1c222a36338ea6d402073341f42"},
        {"00000000000000000400000000000000", "00000000000000000000000000000000", "ced5dfdf8b5d1d60e9ad51830a7965a9"},
        {"00000000000000000200000000000000", "00000000000000000000000000000000", "4ffae5d7a5689a5584330cb0a5cc9cd2"},
        {"00000000000000000100000000000000", "00000000000000000000000000000000", "1dd688d47541463915f658bb656420b4"},
        {"00000000000000000080000000000000", "00000000000000000000000000000000", "ef3a1c1800dd3cda748fbdf17086ba4f"},
        {"00000000000000000040000000000000", "00000000000000000000000000000000", "f9aa9b3e76543ef12f7f8b87ce393328"},
        {"00000000000000000020000000000000", "00000000000000000000000000000000", "1813935bb67dc40dc37c68cc2999758a"},
        {"00000000000000000010000000000000", "00000000000000000000000000000000", "8c4916d59fce8eb913b128f2d7b3d464"},
        {"00000000000000000008000000000000", "00000000000000000000000000000000", "bb88da704c5ce031c61954efcae6ed2d"},
        {"00000000000000000004000000000000", "00000000000000000000000000000000", "4e463bceb0f52c3f722e2926c2bd04a3"},
        {"00000000000000000002000000000000", "00000000000000000000000000000000", "4a6181492a454604293396bbd21c4956"},
        {"00000000000000000001000000000000", "00000000000000000000000000000000", "801f29d5462365735a6ca7a64288f48c"},
        {"00000000000000000000800000000000", "00000000000000000000000000000000", "7933733c4daab746ef048edba2d05538"},
        {"00000000000000000000400000000000", "00000000000000000000000000000000", "4127c1d95431fd2632f2b5e5085a3dd8"},
        {"00000000000000000000200000000000", "00000000000000000000000000000000", "0588168ca7525333460c4030af266388"},
        {"00000000000000000000100000000000", "00000000000000000000000000000000", "32b3f193d7237b48883de002b3cbe1c3"},
        {"00000000000000000000080000000000", "00000000000000000000000000000000", "7ca557bc05b845a233c01412022da825"},
        {"00000000000000000000040000000000", "00000000000000000000000000000000", "54f11361ad6dfbb069be67536cc98d81"},
        {"00000000000000000000020000000000", "00000000000000000000000000000000", "a9df031b4e25e89f527efff89cb0beba"},
        {"00000000000000000000010000000000", "00000000000000000000000000000000", "7da4d0d6309906d935ba27ae00cfaf33"},
        {"00000000000000000000008000000000", "00000000000000000000000000000000", "e231ea0fec29d983d3236bb15e7cd1da"},
        {"00000000000000000000004000000000", "00000000000000000000000000000000", "fe1b963a4f596422a6cd7787f4ab3377"},
        {"00000000000000000000002000000000", "00000000000000000000000000000000", "848833f2f7a247d2e1d0c8614694139f"},
        {"00000000000000000000001000000000", "00000000000000000000000000000000", "630bb1dc4e60d3272b6b673bdb918b20"},
        {"00000000000000000000000800000000", "00000000000000000000000000000000", "500251a5c6ad5a6d2f218a3fd5765727"},
        {"00000000000000000000000400000000", "00000000000000000000000000000000", "d019ef316e84149cfd0e85665aa2fff5"},
        {"00000000000000000000000200000000", "00000000000000000000000000000000", "db0b5ac0e8ef011d710323fa3b8bb3a7"},
        {"00000000000000000000000100000000", "00000000000000000000000000000000", "207e46a533617374d2c9da0c92ffd620"},
        {"00000000000000000000000080000000", "00000000000000000000000000000000", "8273ca155249f9f1ad8cc2ca114984f3"},
        {"00000000000000000000000040000000", "00000000000000000000000000000000", "82a73a18aae84ad671e226470f246e1a"},
        {"00000000000000000000000020000000", "00000000000000000000000000000000", "3e0e1206e333917d4c250bd82fef6afd"},
        {"00000000000000000000000010000000", "00000000000000000000000000000000", "2182f67239be15c796439ea3791202e1"},
        {"00000000000000000000000008000000", "00000000000000000000000000000000", "486fb3fa7b1fe1a304cb4e8960c3c6bb"},
        {"00000000000000000000000004000000", "00000000000000000000000000000000", "c1de50e456c4308d5d70da141cef0b4f"},
        {"00000000000000000000000002000000", "00000000000000000000000000000000", "a623f24515a27cee3dad277429000218"},
        {"00000000000000000000000001000000", "00000000000000000000000000000000", "02fa5762f9cd90201565bce71140c6f4"},
        {"00000000000000000000000000800000", "00000000000000000000000000000000", "a643a0ca5154a7d10b251d562d58ea53"},
        {"00000000000000000000000000400000", "00000000000000000000000000000000", "48660e32b1c7ee7085e5b5e9f719c790"},
        {"00000000000000000000000000200000", "00000000000000000000000000000000", "a96366bb17b67e161fd8e33c3e1f3d2a"},
        {"00000000000000000000000000100000", "00000000000000000000000000000000", "5659ab825fc2de031a6998cacd741ff6"},
        {"00000000000000000000000000080000", "00000000000000000000000000000000", "1253e9e4079e9b573a73cf4ce08dc015"},
        {"00000000000000000000000000040000", "00000000000000000000000000000000", "28205442270c735d4ba79042dce81509"},
        {"00000000000000000000000000020000", "00000000000000000000000000000000", "98cfb10f3ed70bb82cc90597b463a1f6"},
        {"00000000000000000000000000010000", "00000000000000000000000000000000", "cab40433631fe3a272fc401255a58064"},
        {"00000000000000000000000000008000", "00000000000000000000000000000000", "abb041d85114da88e65e8bdcf1c67cc8"},
        {"00000000000000000000000000004000", "00000000000000000000000000000000", "00f0926f0f9eaa0a6238dfce79c8f596"},
        {"00000000000000000000000000002000", "00000000000000000000000000000000", "7c662d01b12d9845705b2bd4d7aef43d"},
        {"00000000000000000000000000001000", "00000000000000000000000000000000", "8f1cc7a0fbe7d70a894d09e12fb22bb8"},
        {"00000000000000000000000000000800", "00000000000000000000000000000000", "ebe03d0c6752d0edfebff879c33d8c07"},
        {"00000000000000000000000000000400", "00000000000000000000000000000000", "b74ce7f67bbd969e8ff8862d1fb1715c"},
        {"00000000000000000000000000000200", "00000000000000000000000000000000", "63ad5ea9d599ec848a40d489c0b85e8a"},
        {"00000000000000000000000000000100", "00000000000000000000000000000000", "4e4167f091ea5776e80fb2fca38c2a04"},
        {"00000000000000000000000000000080", "00000000000000000000000000000000", "dbf0cea3a5ed5b884ac13a2a62c32d51"},
        {"00000000000000000000000000000040", "00000000000000000000000000000000", "7e86285068a376a3b9fe8641a38e3f90"},
        {"00000000000000000000000000000020", "00000000000000000000000000000000", "aec1ef8d651a2cf7b5475fcc7fb7a81a"},
        {"00000000000000000000000000000010", "00000000000000000000000000000000", "fda539d910181ce1a1e1db4c3459600b"},
        {"00000000000000000000000000000008", "00000000000000000000000000000000", "f8072bf053d5b5163949ff0b9bb3f81a"},
        {"00000000000000000000000000000004", "00000000000000000000000000000000", "a31eb966d34ed6a6132a6b6e9128e997"},
        {"00000000000000000000000000000002", "00000000000000000000000000000000", "673aebbff82091a19e758ece151811d0"},
        {"00000000000000000000000000000001", "00000000000000000000000000000000", "369bdb6f102d6bfea7645b1a6753bf37"},
        {"80000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "ffd90e8a92a1b025108168714f7923f7"},
        {"40000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "64e10ab587bc5d996cf2186c2ff2dd58"},
        {"20000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "eaa404b51336a16c963735588b0b2a0c"},
        {"10000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "51aaa1e37cb08cf5c6ec9241ac36b4c5"},
        {"08000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "c21b34c3c077b30add67d0e2e75e59ec"},
        {"04000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "f33ccd4771932f5e467552e93ae367ab"},
        {"02000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "b70b9f3a5814ddeb6d3549d88c5b4656"},
        {"01000000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "5c01c66e9bf9617b155d3902722ccadc"},
        {"00800000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "1f47def31d2e7e286172b38119fde307"},
        {"00400000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "bd3c2f005cf0eb5ef737c29f457ed549"},
        {"00200000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "1d409243f79ce876d13b0fdfea26ccf8"},
        {"00100000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "b879e37c2f435b0cb941f74892c1476f"},
        {"00080000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "58c6a8884bf8b110c9127893976a9e4e"},
        {"00040000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "7a258ac14cb88a31432ba1b320d254f6"},
        {"00020000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "ff382f1b4bbb54c9f42b73b256f80d25"},
        {"00010000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "0cef334bcbe5d38e23a9780d2e3e9097"},
        {"00008000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "3225e13778d2a3bab1eb375e034478c4"},
        {"00004000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "4ef73320931377f64e296e49c286e5c9"},
        {"00002000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "adbf2c07f2f42eb7d92acc07f9df7a5f"},
        {"00001000000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "bfca14ad6925ddb4f563048db1c6b485"},
        {"00000800000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "63f01ea46c82dc3b1d81eac5e4f1d687"},
        {"00000400000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "b2f6eb69ce81accc720e705146cfc2a2"},
        {"00000200000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "85b1ff06090504848fdda74dd830e960"},
        {"00000100000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "5bcb44ab29d7c31def58c902c2491333"},
        {"00000080000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "4d982cbc7c1455cde7c0de3f83fcbc5e"},
        {"00000040000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "32f08276e0633e1d819fc6227e631503"},
        {"00000020000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "e6bebd4cddc205399126bfda486ed37c"},
        {"00000010000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "afe39df4f356aea5f07069455010d9ce"},
        {"00000008000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "a8c7b2c1e8e1ade5e28e4104ff716ba5"},
        {"00000004000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "fbb3e4ca3e710a5bd94b50726de5fdb1"},
        {"00000002000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "2091d65d6fbb8672d84655f33dc1473a"},
        {"00000001000000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "9c74519acc53498333791febfd0e5e8b"},
        {"00000000800000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "ed44022a82468ed54203b5863b63061f"},
        {"00000000400000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "eae325499a1a9e8e1bd4d6f018e65551"},
        {"00000000200000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "b134fe1498d7a1d926d3a623ffa5723e"},
        {"00000000100000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "343f8d08a35c272c5cd4064a42a7b6d8"},
        {"00000000080000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "79230ea5d7f6b5d85922ed7679aebe08"},
        {"00000000040000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "d3f799e3579c68e10fb1c770b1cbb7c7"},
        {"00000000020000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "90c24054dc24772ecd92a67a43335320"},
        {"00000000010000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "bf38cfda7b75a478fa73316801883d34"},
        {"00000000008000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "4323a85f7921a4a1fc072b72b6b46f50"},
        {"00000000004000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "3e10218fdefd9a0b91d9032d793aecc8"},
        {"00000000002000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "66a759ec5e5cdd9c27a4e97ff0b5aab8"},
        {"00000000001000000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "3730876a26727d44a46404f69ba99f09"},
        {"00000000000800000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "b277bd5a0e78eafc049bd9aa3393870f"},
        {"00000000000400000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "af05cdd3a6dd19fb0199933bdea3c20f"},
        {"00000000000200000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "0d962ec5f824d922924f3c39339fa934"},
        {"00000000000100000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "de695dab525ffebc039f63c3defb200b"},
        {"00000000000080000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "f8ce4303ff6a523a60e3526a28c1c1de"},
        {"00000000000040000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "c00c5250a33165254408992f6aa1fb97"},
        {"00000000000020000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "7e81d9c10bc3ac8fcac65079867183ff"},
        {"00000000000010000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "42f91fe46e5f6485973123b586cc2517"},
        {"00000000000008000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "0900c5c4bb963e1e421571056aeda9f0"},
        {"00000000000004000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "933312932700ef9c82333913782fc8fb"},
        {"00000000000002000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "d78181179ac4cc05f38a1d134b29b70a"},
        {"00000000000001000000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "411b9bd8a8c3d3c9a2c375d28a336c4a"},
        {"00000000000000800000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "632433f8708bd47d6a083adbdf3a8982"},
        {"00000000000000400000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "f037e3fcd3db611bd777420b8170df1b"},
        {"00000000000000200000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "31da207bfbdbb93157408ad2d7e559df"},
        {"00000000000000100000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "2837b13cb713b5fde1bc07cb7b2613d9"},
        {"00000000000000080000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "c31906513814506753848c50ab7c8d13"},
        {"00000000000000040000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "014b54ca9f1d87c7711af20119b03afc"},
        {"00000000000000020000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "060903be7b215ee51fbce79205b0515a"},
        {"00000000000000010000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "f91da002995fe07969ff63b8673fa75a"},
        {"00000000000000008000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "65a8b07ad4f77c8be4f27f975a42f2e7"},
        {"00000000000000004000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "31a157653449da846b5dade80e2f3ae8"},
        {"00000000000000002000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "1be98428352aeab7534e12463898bde5"},
        {"00000000000000001000000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "a7a50bec385145e784486d6d70552fbf"},
        {"00000000000000000800000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "eaacafae73701d566b24ab68350c4cb7"},
        {"00000000000000000400000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "deef8a7a5de90caaa0e3412356518d9a"},
        {"00000000000000000200000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "8d4373f4933353f589e42471ef35836c"},
        {"00000000000000000100000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "01436b7d351b9ff0fe85dab7ef77a020"},
        {"00000000000000000080000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "a6b2b93c4c6dafea4db5a4ecfee2c561"},
        {"00000000000000000040000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "7b0f7781683d890db4582d4399b07fab"},
        {"00000000000000000020000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "01c82b395331de265555d72df29c7efc"},
        {"00000000000000000010000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "5d9ba76d5b20b4b88b70b80c20c5e350"},
        {"00000000000000000008000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "92b2a69dd8a75d2edb01644a0b975c15"},
        {"00000000000000000004000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "e2f6e46a2a899615969f4b751d55d57f"},
        {"00000000000000000002000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "97427298315d058eb2f7cdabd4a851c8"},
        {"00000000000000000001000000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "8f0f710a0cc1d6049ebb01974b76caad"},
        {"00000000000000000000800000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "2cf62d9d02afb40eed66fedb53c2db5c"},
        {"00000000000000000000400000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "fb215ab9ec3fafc5fd91cd9ad3cee2be"},
        {"00000000000000000000200000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "4a37472335edaf7393a304d45a233085"},
        {"00000000000000000000100000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "d22a878d2ca3a88f34acc92a4e26c738"},
        {"00000000000000000000080000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "f1a95970638dcbc69c4675e895370904"},
        {"00000000000000000000040000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "1660060085c0e241f88462bffbe67602"},
        {"00000000000000000000020000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "a097acb2eb5f779090f886beae746ae1"},
        {"00000000000000000000010000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "9ffe05163407ba53b62a35d857f58bc6"},
        {"00000000000000000000008000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "dfed8392eec1b389cbc261faf97c5c9e"},
        {"00000000000000000000004000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "d2c1b3159129d86959f3aa9b70219a74"},
        {"00000000000000000000002000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "98c043b2e86cff626abf5fbc745d98a6"},
        {"00000000000000000000001000000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "35c5aed481c801a0ca78842273e0186d"},
        {"00000000000000000000000800000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "ddaac5c7f13943e80d2244a4a19e9980"},
        {"00000000000000000000000400000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "51dbf12fc81e5ffe9b1ce9963636205f"},
        {"00000000000000000000000200000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "38ee89874d644ccdf9694280a6c48182"},
        {"00000000000000000000000100000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "c3bc93ca8e8800622c92c56b99262ae2"},
        {"00000000000000000000000080000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "dc2c2b7558f75b71a9db34e971892171"},
        {"00000000000000000000000040000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "609bd72078f92ae345dcde14e6aba0e0"},
        {"00000000000000000000000020000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "cabc8bdda6e1979199f5010c3f8b8a31"},
        {"00000000000000000000000010000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "c993d659ba4426dc30f8dc7ea03cd2ee"},
        {"00000000000000000000000008000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "5dd47466cbb15dca1485e04231d7491c"},
        {"00000000000000000000000004000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "e1351ce84ded187e0f5aab9bb7198387"},
        {"00000000000000000000000002000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "e5222c68fda26e5e62929c70233ad097"},
        {"00000000000000000000000001000000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "78cc456147db73850328241bdff861c0"},
        {"00000000000000000000000000800000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "4f10436e3ba4f38cd96744b897d5a136"},
        {"00000000000000000000000000400000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "12b698464abcb67c3956c5d1b9c62dfd"},
        {"00000000000000000000000000200000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "49de5db3e7d997c56dd2f82935e6617f"},
        {"00000000000000000000000000100000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "71ea115e54775680f16b1b9d7b2ee367"},
        {"00000000000000000000000000080000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "45b7e46c664a472af948b0c393f92af1"},
        {"00000000000000000000000000040000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "db3678b993ef5e48931b5bf84cece6eb"},
        {"00000000000000000000000000020000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "051c9a17d4ca77eabd8b9d9a1bce52d6"},
        {"00000000000000000000000000010000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "e805aeeac134761ff7b3260bb4308a10"},
        {"00000000000000000000000000008000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "3301700109b460c7e41a51059f33004f"},
        {"00000000000000000000000000004000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "d71f178093314e188bae26dde5a78927"},
        {"00000000000000000000000000002000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "31bb9cb46fbf607fcaa5932851899420"},
        {"00000000000000000000000000001000", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "ea77bcd0ce469ab47a828dc6324c3651"},
        {"00000000000000000000000000000800", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "e4596b0d33bdeb062a7ddb93e6efae94"},
        {"00000000000000000000000000000400", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "24d04f34b837461cd3b8d9c13afe6fe5"},
        {"00000000000000000000000000000200", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "ffb68c9ae4d7d2642bf5bee57d2bd914"},
        {"00000000000000000000000000000100", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "c008d35eb9de15700c0491319e6415f0"},
        {"00000000000000000000000000000080", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "92bfbbfcd2bbf54fff06af097893e9a3"},
        {"00000000000000000000000000000040", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "d2475279191bc4da183ee2dba75fce6d"},
        {"00000000000000000000000000000020", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "7b8adf2ef0e1f5fbb19cbd4b8fab1426"},
        {"00000000000000000000000000000010", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "0b07b9c4385bdc86447f535e09a9f424"},
        {"00000000000000000000000000000008", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "e7308875d8d6645719c076dd1660924b"},
        {"00000000000000000000000000000004", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "bc50d54a891d6102d0c02f471f1f0567"},
        {"00000000000000000000000000000002", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "2b14534ca7d9821a40b101035f681f0d"},
        {"00000000000000000000000000000001", "0f1e2d3c4b5a69788796a5b4c3d2e1f0", "69bd984641e0aa887bc23738f60070db"}
    };


    protected TestSquare()
    {
        super(NAME);
    }


    protected void doIt()
    throws Exception
    {
        testCipher(TEST_VALUES);
    }
}
