/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.rsa.RSAAlgorithm;
import cryptix.jce.provider.util.Util;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public abstract class RSASignature_PKCS1
extends SignatureSpi {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger n;
    private BigInteger exp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private final MessageDigest md;

    RSASignature_PKCS1(String mdAlgorithm) {
        try {
            this.md = MessageDigest.getInstance(mdAlgorithm);
        }
        catch (Exception exception) {
            throw new InternalError("Unable to instantiate messagedigest:" + mdAlgorithm);
        }
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not have parameters.");
    }

    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Not an RSA private key");
        }
        RSAPrivateKey rsa = (RSAPrivateKey)key;
        this.n = rsa.getModulus();
        this.exp = rsa.getPrivateExponent();
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey crt = (RSAPrivateCrtKey)key;
            this.p = crt.getPrimeP();
            this.q = crt.getPrimeQ();
            this.u = crt.getCrtCoefficient();
        } else {
            this.u = null;
            this.q = null;
            this.p = null;
        }
        this.initCommon();
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.engineInitSign(privateKey);
    }

    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Not an RSA public key");
        }
        RSAPublicKey rsa = (RSAPublicKey)key;
        this.n = rsa.getModulus();
        this.exp = rsa.getPublicExponent();
        this.u = null;
        this.q = null;
        this.p = null;
        this.initCommon();
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not accept parameters.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This algorithm does not accept AlgorithmParameterSpec.");
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger pkcs = this.makePKCS1();
        BigInteger result = RSAAlgorithm.rsa(pkcs, this.n, this.exp, this.p, this.q, this.u);
        return Util.toFixedLenByteArray(result, this.modulusByteLength());
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.md.update(b);
    }

    protected void engineUpdate(byte[] in, int offset, int length) throws SignatureException {
        this.md.update(in, offset, length);
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        BigInteger M = new BigInteger(1, signature);
        BigInteger computed = RSAAlgorithm.rsa(M, this.n, this.exp, this.p, this.q, this.u);
        BigInteger actual = this.makePKCS1();
        return computed.equals(actual);
    }

    protected abstract byte[] getAlgorithmEncoding();

    private void initCommon() throws InvalidKeyException {
        this.md.reset();
        int mdl = this.md.digest().length;
        int length = this.modulusByteLength();
        int aidl = this.getAlgorithmEncoding().length;
        int padLen = length - 3 - aidl - mdl;
        if (padLen < 0) {
            throw new InvalidKeyException("Signer's key modulus too short.");
        }
    }

    private BigInteger makePKCS1() throws SignatureException {
        byte[] theMD = this.md.digest();
        int mdl = theMD.length;
        int length = this.modulusByteLength();
        byte[] r = new byte[length];
        r[1] = 1;
        byte[] aid = this.getAlgorithmEncoding();
        int aidl = aid.length;
        int padLen = length - 3 - aidl - mdl;
        if (padLen < 0) {
            throw new SignatureException("Signer's public key modulus too short.");
        }
        int i = 0;
        while (i < padLen) {
            r[2 + i++] = -1;
        }
        System.arraycopy(aid, 0, r, padLen + 3, aidl);
        System.arraycopy(theMD, 0, r, length - mdl, mdl);
        return new BigInteger(r);
    }

    private int modulusByteLength() {
        return (this.n.bitLength() + 7) / 8;
    }
}

