/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.ExemptionMechanismSpi;
import javax.crypto.ShortBufferException;
import javax.crypto.Support;

public class ExemptionMechanism {
    private final ExemptionMechanismSpi spi;
    private final Provider provider;
    private final String mechanism;
    private boolean isInitialized = false;

    protected ExemptionMechanism(ExemptionMechanismSpi exmechSpi, Provider provider, String mechanism) {
        this.spi = exmechSpi;
        this.provider = provider;
        this.mechanism = mechanism;
    }

    protected void finalize() {
        throw new RuntimeException("Method not yet implemented!");
    }

    public final byte[] genExemptionBlob() throws IllegalStateException, ExemptionMechanismException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        return this.spi.engineGenExemptionBlob();
    }

    public final int genExemptionBlob(byte[] output) throws IllegalStateException, ShortBufferException, ExemptionMechanismException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        if (output.length < this.getOutputSize(0)) {
            throw new ShortBufferException("Buffer to short!");
        }
        return this.spi.engineGenExemptionBlob(output, 0);
    }

    public final int genExemptionBlob(byte[] output, int outputOffset) throws IllegalStateException, ShortBufferException, ExemptionMechanismException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        if (output.length - outputOffset < this.getOutputSize(0)) {
            throw new ShortBufferException("Buffer to short!");
        }
        return this.spi.engineGenExemptionBlob(output, outputOffset);
    }

    public static final ExemptionMechanism getInstance(String mechanism) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("ExemptionMechanism", mechanism);
        return new ExemptionMechanism((ExemptionMechanismSpi)o[0], (Provider)o[1], mechanism);
    }

    public static final ExemptionMechanism getInstance(String mechanism, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("ExemptionMechanism", mechanism, provider);
        return new ExemptionMechanism((ExemptionMechanismSpi)o[0], (Provider)o[1], mechanism);
    }

    public final String getName() {
        return this.mechanism;
    }

    public final int getOutputSize(int inputLen) throws IllegalStateException {
        if (!this.isInitialized) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        return this.spi.engineGetOutputSize(inputLen);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException, ExemptionMechanismException {
        this.spi.engineInit(key);
        this.isInitialized = true;
    }

    public final void init(Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException, ExemptionMechanismException {
        this.spi.engineInit(key, params);
        this.isInitialized = true;
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException, ExemptionMechanismException {
        this.spi.engineInit(key, params);
        this.isInitialized = true;
    }

    public final boolean isCryptoAllowed(Key key) throws ExemptionMechanismException {
        throw new RuntimeException("Method not yet implemented");
    }
}

