/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.provider.md.SHA1;
import cryptix.jce.test.MessageDigestTest;

final class TestSHA1
extends MessageDigestTest {
    private static final String NAME = "SHA1";
    String[][] TEST_VALUES = new String[][]{{"", "da39a3ee5e6b4b0d3255bfef95601890afd80709"}, {"1", "356a192b7913b04c54574d18c28d46e6395428ab"}, {"a", "86f7e437faa5a7fce15d1ddcb9eaeaea377667b8"}, {"abc", "a9993e364706816aba3e25717850c26c9cd0d89d"}, {"abcdefghijklmnopqrstuvwxyz", "32d10c7b8cf96570ca04ce37f2a19d84240d3a89"}, {"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", "84983E441C3BD26EBAAE4AA1F95129E5E54670F1"}, {"Anyone got any SHA-1 test data?", "09b9e9c04a84ce274942048acf3a6f2ff4a8a39c"}, {"Of cabbages and kings", "5f093d74a9cb1f2f14537bcf3a8a1ffd59b038a2"}};
    private static final String LARGE_STRING_VALUE = "34AA973CD4C4DAA4F61EEB2BDBAD27316534016F";

    protected TestSHA1() {
        super(NAME);
    }

    protected void doIt() throws Exception {
        SHA1 foo = new SHA1();
        this.testExistence(NAME);
        this.testExistence("SHA");
        this.testExistence("SHA-1");
        this.testValues(NAME, this.TEST_VALUES);
        this.testLargeString(NAME, (byte)97, 1000000, LARGE_STRING_VALUE);
        this.testCloning(NAME);
    }
}

