/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.InsecureRandom;
import cryptix.jce.test.Test;
import cryptix.jce.test.Util;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

public final class TestRSA_OAEP
extends Test {
    private static final String PROVIDER = "CryptixCrypto";
    private static final String KALG = "RSA";
    private static final String ALG = "RSAES-OAEP-SHA1";
    private static int SIZE = 768;
    private static final String N = "a8b3b284af8eb50b387034a860f146c4919f318763cd6c5598c8ae4811a1e0abc4c7e0b082d693a5e7fced675cf4668512772c0cbc64a742c6c630f533c8cc72f62ae833c40bf25842e984bb78bdbf97c0107d55bdb662f5c4e0fab9845cb5148ef7392dd3aaff93ae1e6b667bb3d4247616d4f5ba10d4cfd226de88d39f16fb";
    private static final String E = "010001";
    private static final String D = "53339cfdb79fc8466a655c7316aca85c55fd8f6dd898fdaf119517ef4f52e8fd8e258df93fee180fa0e4ab29693cd83b152a553d4ac4d1812b8b9fa5af0e7f55fe7304df41570926f3311f15c4d65a732c483116ee3d3d2d0af3549ad9bf7cbfb78ad884f84d5beb04724dc7369b31def37d0cf539e9cfcdd3de653729ead5d1";
    private static final String P = "d32737e7267ffe1341b2d5c0d150a81b586fb3132bed2f8d5262864a9cb9f30af38be448598d413a172efb802c21acf1c11c520c2f26a471dcad212eac7ca39d";
    private static final String Q = "cc8853d1d54da630fac004f471f281c7b8982d8224a490edbeb33d3e3d5cc93c4765703d1dd791642f1f116a0dd852be2419b2af72bfe9a030e860b0288b5d77";
    private static final String dP = "0e12bf1718e9cef5599ba1c3882fe8046a90874eefce8f2ccc20e4f2741fb0a33a3848aec9c9305fbecbd2d76819967d4671acc6431e4037968db37878e695c1";
    private static final String dQ = "95297b0f95a2fa67d00707d609dfd4fc05c89dafc2ef6d6ea55bec771ea333734d9251e79082ecda866efef13c459e1a631386b7e354c899f5f112ca85d71583";
    private static final String qI = "4f456c502493bdc0ed2ab756a3a6ed4d67352a697d4216e93212b127a63d5411ce6fa98d5dbefd73263e3728142743818166ed7dd63687dd2a8ca1d2f4fbd8e1";
    private static final String PT = "6628194e12073db03ba94cda9ef9532397d50dba79b987004afefe34";
    private static final String SD = "18b776ea21069d69776a33e96bad48e1dda0a5ef";
    private static final String CT = "354fe67b4a126d5d35fe36c777791a3f7ba13def484e2d3908aff722fad468fb21696de95d0be911c2d3174f8afcc201035f7b6d8e69402de5451618c21a535fa9d7bfc5b8dd9fc243f8cf927db31322d6e881eaa91a996170e657a05a266426d98c88003f8477c1227094a0d9fa1e8c4024309ce1ecccb5210035d47ac72e8a";

    public TestRSA_OAEP() {
        super("RSAES-OAEP");
    }

    private void cryptWithRandomKey() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(KALG, PROVIDER);
        kpg.initialize(SIZE);
        KeyPair kp = kpg.genKeyPair();
        RSAPrivateKey priv = (RSAPrivateKey)kp.getPrivate();
        RSAPublicKey pub = (RSAPublicKey)kp.getPublic();
        Cipher c = Cipher.getInstance(ALG, PROVIDER);
        c.init(1, pub);
        byte[] pt = Util.hexFromString(PT);
        byte[] ct = c.doFinal(pt);
        c = Cipher.getInstance(ALG, PROVIDER);
        c.init(2, priv);
        byte[] pt1 = c.doFinal(ct);
        if (!Util.areEqual(pt, pt1)) {
            throw new Exception("Failed!");
        }
    }

    protected void doIt() throws Exception {
        this.doTest1();
        this.doTest2();
    }

    protected void doTest1() throws Exception {
        this.beginTest("Test Vectors");
        RSAPublicKey pub = new RSAPublicKey(){

            public String getAlgorithm() {
                return TestRSA_OAEP.KALG;
            }

            public byte[] getEncoded() {
                return null;
            }

            public String getFormat() {
                return TestRSA_OAEP.KALG;
            }

            public BigInteger getModulus() {
                return new BigInteger(1, Util.hexFromString(TestRSA_OAEP.N));
            }

            public BigInteger getPublicExponent() {
                return new BigInteger(1, Util.hexFromString(TestRSA_OAEP.E));
            }
        };
        RSAPrivateKey priv = new RSAPrivateKey(){

            public String getAlgorithm() {
                return TestRSA_OAEP.KALG;
            }

            public byte[] getEncoded() {
                return null;
            }

            public String getFormat() {
                return TestRSA_OAEP.KALG;
            }

            public BigInteger getModulus() {
                return new BigInteger(1, Util.hexFromString(TestRSA_OAEP.N));
            }

            public BigInteger getPrivateExponent() {
                return new BigInteger(1, Util.hexFromString(TestRSA_OAEP.D));
            }
        };
        InsecureRandom rng = new InsecureRandom(Util.hexFromString(SD));
        byte[] pt = Util.hexFromString(PT);
        Cipher c = Cipher.getInstance(ALG, PROVIDER);
        c.init(1, (Key)pub, (SecureRandom)rng);
        byte[] ct = c.doFinal(pt);
        c.init(2, (Key)priv, (SecureRandom)rng);
        byte[] pt1 = c.doFinal(ct);
        this.passIf(Util.areEqual(pt, pt1));
    }

    protected void doTest2() throws Exception {
        int ROUNDS = 100;
        this.beginTest(String.valueOf(ROUNDS) + " Random Keys");
        int i = 0;
        while (i < ROUNDS) {
            this.cryptWithRandomKey();
            ++i;
        }
        this.passIf(true);
    }
}

