/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

final class TestModeAndPadding
extends Test {
    private static final String name = "ModeAndPadding";
    private final String s1 = "ThisIsSecretSecretMessageInText!";
    private final String s2 = "ThisIsSecretMessage";
    private Cipher c;
    private Cipher d;
    private SecretKey sk;
    private String algo;
    private int KEY_SIZE;

    protected TestModeAndPadding() {
        super(name);
        this.algo = "DES";
        this.KEY_SIZE = 56;
    }

    protected TestModeAndPadding(String algo, int KEY_SIZE) {
        super(name);
        this.algo = algo;
        this.KEY_SIZE = KEY_SIZE;
    }

    private void changeMode(String mode, String padding) throws Exception {
        String alg = String.valueOf(this.algo) + "/" + mode + "/" + padding;
        this.c = Cipher.getInstance(alg);
        this.d = Cipher.getInstance(alg);
        this.c.init(1, this.sk);
        if (mode.equals("ECB")) {
            this.d.init(2, this.sk);
        } else {
            this.d.init(2, (Key)this.sk, new IvParameterSpec(this.c.getIV()));
        }
    }

    protected void doIt() throws Exception {
        this.init();
        this.beginTest("ECB mode with no padding");
        this.changeMode("ECB", "NONE");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretSecretMessageInText!") && this.test2(this.c, this.d, "ThisIsSecretSecretMessageInText!"));
        this.beginTest("ECB mode with PKCS5 padding");
        this.changeMode("ECB", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("CBC mode with no padding");
        this.changeMode("CBC", "NoPadding");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretSecretMessageInText!") && this.test2(this.c, this.d, "ThisIsSecretSecretMessageInText!"));
        this.beginTest("CBC mode with PKCS5 padding");
        this.changeMode("CBC", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("OFB mode with no padding");
        this.changeMode("OFB", "NONE");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("OFB mode with PKCS5 padding");
        this.changeMode("OFB", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("CFB mode with no padding");
        this.changeMode("CFB56", "None");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
        this.beginTest("CFB mode with PKCS5 padding");
        this.changeMode("CFB", "PKCS5");
        this.passIf(this.test1(this.c, this.d, "ThisIsSecretMessage") && this.test2(this.c, this.d, "ThisIsSecretMessage"));
    }

    private void init() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(this.algo);
        kg.init(this.KEY_SIZE);
        this.sk = kg.generateKey();
    }

    private boolean test1(Cipher c, Cipher d, String s) throws Exception {
        byte[] e = c.update(s.getBytes());
        byte[] f = c.doFinal();
        byte[] g = new byte[e.length + f.length];
        System.arraycopy(e, 0, g, 0, e.length);
        System.arraycopy(f, 0, g, e.length, f.length);
        return s.equals(new String(d.doFinal(g)));
    }

    private boolean test2(Cipher c, Cipher d, String s) throws Exception {
        byte[] e = c.doFinal(s.getBytes());
        return s.equals(new String(d.doFinal(e)));
    }
}

