/* 
 * ThatIP-J Copyright 2003 Algenta Technologies All rights reserved.
 * Use is subject to license terms.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * $Id: CrossIPException.java,v 1.2 2004/01/25 01:34:20 dan Exp $
 * 
 * $Log: CrossIPException.java,v $
 * Revision 1.2  2004/01/25 01:34:20  dan
 * jdk 1.2 and 1.3 compat
 *
 * Revision 1.1  2003/12/08 11:48:05  dan
 * CrossIP initial commit
 *
 */
package com.algenta.crossip;
/**
 * @author Dan Smith (<a href="mailto:dan (is at) algenta (dot) com">dan (is at) algenta (dot) com</a>)
 *
 */
public class CrossIPException extends Exception {

	private Throwable cause = null;
	private String message = "";
	
	/**
	 * @param string
	 * @param cause
	 */
	public CrossIPException(String string, Throwable cause) {
//		jdk 1.2 and 1.3 do not have inner exceptions
//		super(string,e);
		this.cause = cause;
		this.message = string;
	}
	
	public Throwable getInnerException() {
		return cause;
	}
	

	public String getMessage() {
		return message;
	}

	/**
	 * @param string
	 */
	public CrossIPException(String string) {	
		this.message = string;
	}

}
