/* 
 * ThatIP-J Copyright 2003 Algenta Technologies All rights reserved.
 * Use is subject to license terms.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * $Id: Actions.java,v 1.3 2004/02/09 19:10:30 dan Exp $
 * 
 * $Log: Actions.java,v $
 * Revision 1.3  2004/02/09 19:10:30  dan
 * Protocol v 1.1
 *
 * Revision 1.2  2004/01/25 01:34:20  dan
 * jdk 1.2 and 1.3 compat
 *
 * Revision 1.1  2003/12/08 11:48:05  dan
 * CrossIP initial commit
 *
 */
package com.algenta.crossip;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import com.algenta.util.StringUtils;

/**
 * @author Dan Smith (<a href="mailto:dan (is at) algenta (dot) com">dan (is at) algenta (dot) com</a>)
 *
 */
public class Actions {

	private Hashtable auto = new Hashtable(5);
	private Hashtable client = new Hashtable(5);
	
	/**
	 * @param groupId
	 * @param ipAddr
	 */
	public void autoUpdate(String groupId, String ipAddr) {
		auto.put(groupId,ipAddr);
	}

	public void autoUpdate(String[] groupId, String ipAddr) {
		for(int i = 0; i < groupId.length; ++i){
			auto.put(groupId[i],ipAddr);
		}	
	}
	
	/**
	 * @param groupId
	 * @param ipAddr
	 */
	public void clientUpdate(String groupId, String ipAddr) {
		client.put(groupId,ipAddr);
	}
	public void clientUpdate(String[] groupId, String ipAddr) {
		for(int i = 0; i < groupId.length; ++i){
			client.put(groupId[i],ipAddr);
		}
	}	


	/**
	 * returns a list of groups that have a different ip as determined by the client
	 * @param groupId
	 * @param currentIP
	 * @return list of groups
	 */
	public String[] clientIP(String[] groupId, String currentIP) {
		Vector v = new Vector(groupId.length);
		String last = "";
		for (int i = 0; i < groupId.length; ++i) {
			if (client.containsKey(groupId[i])) {		
				last = (String) client.get(groupId[i]);
				if (currentIP == null) {
					v.add(groupId[i]);
				} else if (last.compareToIgnoreCase(currentIP) != 0) {
					v.add(groupId[i]);
				}
			}			
		}
		String[] r = new String[v.size()];
		for(int i = 0; i < v.size(); ++i) {
			r[i] = (String)v.get(i);
		}
		return r;
		
	}
	
	/**
	 * returns a list of groups that have their ip as determined by the server
	 * @param groupId
	 * @return list of groups
	 */
	public String[] autoIP(String[] groupId) {
		Vector v = new Vector(groupId.length);
		String last = "";
		for (int i = 0; i < groupId.length; ++i) {
			if (auto.containsKey(groupId[i])) {		
				v.add(groupId[i]);				
			}			
		}
		String[] r = new String[v.size()];
		for(int i = 0; i < v.size(); ++i) {
			r[i] = (String)v.get(i);
		}
		return r;
		
	}
			
	public void load(String line) {
		String params[] = StringUtils.Split(line,"\t");
		
			if (params[0].equalsIgnoreCase("auto")) {
				if (params.length == 3) {
					auto.put(params[1],params[2]);
				} else if (params.length == 2) {
					auto.put(params[1],"unknown");
				}
			} else {
				if (params.length == 3) {
					client.put(params[1],params[2]);
				} else if (params.length == 2) {
					client.put(params[1],"unknown");
				}
			}
		
	}
	/**
	 * @param groupId
	 * @return
	 */
	public String lastIp(String groupId) {
		if (auto.containsKey(groupId)) {
			return (String)auto.get(groupId);
		} else if (client.containsKey(groupId)) {
			return (String)client.get(groupId);
		}
		return ""; 
	}
	
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String s = "# thatip.hosts"+ "\n";
   		s +="# <update-type> <group> <last updated ip>"+ "\n";
		for (Enumeration e = auto.keys(); e.hasMoreElements();) {
			String key = (String)e.nextElement();
			s += "auto\t" + key + "\t" + (String)auto.get(key) + "\n";
		}
		for (Enumeration e = client.keys(); e.hasMoreElements();) {
			String key = (String)e.nextElement();
			s += "client\t" + key + "\t" + (String)client.get(key) + "\n";
		}
		return s;	
	}
}
