/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoPanel;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AirportInfoLabelledTextField
extends AirportInfoPanel {
    public String name;
    public JTextField theField;
    private AirportInfoRecord theRecord;

    public AirportInfoLabelledTextField(String name, AirportInfoRecord theRecord, int fieldSize) {
        this.name = name;
        this.theRecord = theRecord;
        JLabel l = new JLabel(name);
        this.theField = new JTextField(fieldSize);
        this.setLayout(new BorderLayout(5, 5));
        this.add("West", l);
        this.add("East", this.theField);
        this.refreshDisplay();
    }

    public AirportInfoLabelledTextField(String name, AirportInfoRecord theRecord) {
        this.name = name;
        this.theRecord = theRecord;
        this.setUpDisplay();
        this.refreshDisplay();
    }

    private void setUpDisplay() {
        JLabel l = new JLabel(this.name);
        int fieldSize = this.theRecord.maxLength;
        switch (this.theRecord.dataType) {
            case 3: {
                fieldSize = 20;
                break;
            }
            case 1: {
                fieldSize = 15;
                break;
            }
            default: {
                fieldSize *= 3;
            }
            case 0: 
        }
        if (fieldSize > 40) {
            fieldSize = 40;
        }
        this.theField = new JTextField(fieldSize);
        this.setLayout(new BorderLayout(5, 5));
        this.add("West", l);
        this.add("East", this.theField);
    }

    public void refreshDisplay() {
        this.theField.setText(this.theRecord.toString());
    }

    public void writeValue() throws ValueFormatException {
        try {
            this.theRecord.setBytesFromString(this.theField.getText());
        }
        catch (ValueFormatException e) {
            this.theField.selectAll();
            this.theField.requestFocus();
            throw e;
        }
    }

    public void writeValue(String newValue) throws ValueFormatException {
        this.theField.setText(newValue);
        this.writeValue();
        this.refreshDisplay();
    }

    public String getText() {
        return this.theField.getText();
    }
}

