package net.psammead.commonist.ui;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;

import javax.imageio.*;
import javax.swing.*;

import net.psammead.commonist.util.*;
import net.psammead.util.*;

/** displays a single image in full size */
public class FullImageWindow {
	private static final Logger log = new Logger(FullImageWindow.class);
	
	public static void display(final File file, final String programHeading, final Image programIcon) {
		new Thread() { 
			@Override
			public void run() {
				final BufferedImage image;
				try {
					image = ImageIO.read(file);
				}
				catch (IOException e) {
					log.warn("cannot load image: " + file, e);
					return;
				}
				if (image == null) {
					log.warn("cannot load image: " + file);
					return;
				}
				SwingUtilities.invokeLater(
					new Runnable() {
						public void run() {
							new FullImageWindow(file, programHeading, programIcon, image);
						}
					}
				);
			}
		}.start();
	}
	
	/** displays an image in full size */
	public FullImageWindow(File file, String programHeading, Image programIcon, Image image) {
		ImageIcon			icon	= new ImageIcon(image);
		
		ScrollablePicture	label	= new ScrollablePicture();
		label.setHorizontalAlignment(SwingConstants.CENTER);
		label.setVerticalAlignment(SwingConstants.CENTER);
		label.setIcon(icon);
		
		JScrollPane	scroll	= new JScrollPane(label);
		
		String	heading	= file.getName() + " - " + programHeading;
		final JFrame window	= new JFrame(heading);
		window.setIconImage(programIcon);
		window.getContentPane().add(scroll);
		window.pack();
		
		
//		// TODO: seems to break with small images
//		Rectangle	bounds	= UIUtil.boundsInScreen(window.getBounds());
//		bounds.width	= Math.max(bounds.width,	Constants.FULLSIZE_MIN_FRAME_SIZE);
//		bounds.height	= Math.max(bounds.height,	Constants.FULLSIZE_MIN_FRAME_SIZE);
//		window.setBounds(bounds);
		//window.MaximumSize				= window.Size;
		//statt dessen evtl. MaximizedBounds einsetzen
		
		UIUtil.limitAndChangeBounds(window, window.getBounds());
		
		window.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		window.setLocationRelativeTo(null);
		UIUtil.scrollToCenter(scroll);
		window.setVisible(true);
		
		window.getRootPane().registerKeyboardAction(
			new ActionListener() { public void actionPerformed(ActionEvent ev) {
				window.dispose();
			}},
			KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
			JComponent.WHEN_IN_FOCUSED_WINDOW
		);
	}
	
}
