package net.psammead.util.json;

import java.lang.reflect.*;
import java.util.*;

/** converts all public, non-transient and non-static fields of an Object into a Map suitable for JSON */
public final class JSONPublicFieldMapper implements JSONMapper {
	public Object map(Object o) {
		Map<String, Object>	out		= new LinkedHashMap<String, Object>();
		Field[]				fields	= o.getClass().getFields();
		for (Field field : fields) {
			int	modifiers	= field.getModifiers();
			if (!Modifier.isPublic(modifiers))		continue;
			if (Modifier.isTransient(modifiers))	continue;
			if (Modifier.isStatic(modifiers))		continue;
			
			try {
				String	key		= field.getName();
				Object	value	= field.get(o);
				out.put(key, value);
			}
			catch (Exception e) {
				throw new JSONMappingException("mapping field failed: " + field.getName(), e);
			}
		}
		return out;
	}
}
