package net.psammead.util.cache;

import java.util.HashMap;
import java.util.Map;

import net.psammead.util.Function;

/** keys and values are strongly referenced */
public final class StrongCache<S,T> extends BaseCache<S,T> {
	private final Map<S,T>	data;
	
	public StrongCache(Function<? super S,? extends T> loader) {
		super(loader);
		data	= new HashMap<S, T>();
	}
	
	public void clear() {
		data.clear();
	}

	public T apply(S key) {
		T	value	= data.get(key);
		if (value == null) {
			value	=fetch(key);
			data.put(key, value);
		}
		return value;
	}
}
