package net.psammead.util;

public final class Functions {
	private Functions() {}
	
	public static <T> Function<T,T> identity() {
		return new Function<T,T>() {
			public T apply(T source) {
				return source;
			}
		};
	}
	
	public static <S,T> Function<S,T> constant(final T value) {
		return new Function<S,T>() {
			public T apply(S source) {
				return value;
			}
		};
	}
	
	public static <R,S,T> Function<R,T> compose(final Function<R,S> first, final Function<S,T> second) {
		return new Function<R,T>() {
			public T apply(R source) {
				return second.apply(first.apply(source));
			}
		};
	}
	
//	public static <S,T> Function<S,T> nullify() {
//		return constant(null);
//	}
	
	public static <S> Function<S,String> safeToString() {
		return new Function<S,String>() {
			public String apply(S source) {
				return StringUtil.safeToString(source);
			}
		};
	}
}
