/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import java.io.File;
import java.util.List;
import java.util.Map;
import net.psammead.mwapi.Location;
import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.net.IllegalFormException;
import net.psammead.mwapi.net.JerichoUtil;
import net.psammead.mwapi.ui.ProgressCallback;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.ui.UnsupportedURLException;
import net.psammead.mwapi.ui.UploadCallback;
import net.psammead.mwapi.ui.UploadFileExistsException;
import net.psammead.mwapi.ui.UploadFileLargeException;
import net.psammead.mwapi.ui.UploadFileWasDeletedException;
import net.psammead.mwapi.ui.UploadForbiddenException;
import net.psammead.mwapi.ui.action.UiSimpleActionBase;
import net.psammead.mwapi.ui.action.parser.ParsedUploadWarning;
import net.psammead.mwapi.ui.action.response.ResponseData;
import net.psammead.mwapi.ui.action.response.ResponseHandler;
import org.apache.commons.httpclient.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadAction
extends UiSimpleActionBase {
    private final File file;
    private final String description;
    private final String title;
    private final boolean watchThis;
    private final ProgressCallback progressListener;
    private final UploadCallback uploadCallback;
    private Location uploaded;

    public FileUploadAction(MediaWiki mediaWiki, Connection connection, String title, String description, File file, boolean watchThis, ProgressCallback progressListener, UploadCallback callback) {
        this(mediaWiki, connection, title, description, file, false, watchThis, null, progressListener, callback);
    }

    public Location getUploaded() {
        return this.uploaded;
    }

    protected FileUploadAction(MediaWiki mediaWiki, Connection connection, final String title, String description, File file, boolean ignoreWarning, boolean watchThis, String sessionKey, ProgressCallback progressListener, UploadCallback callback) {
        super(mediaWiki, connection);
        this.title = title;
        this.description = description;
        this.file = file;
        this.watchThis = watchThis;
        this.progressListener = progressListener;
        this.uploadCallback = callback;
        this.uploaded = null;
        this.simpleMethod(POST);
        this.simpleTitle(this.specialPage("Upload"));
        this.simpleArg("wpDestFile", title);
        this.simpleArg("wpUploadDescription", description);
        this.simpleArg("wpUpload", "yes");
        if (ignoreWarning) {
            this.simpleArg("wpIgnoreWarning", "1");
        }
        if (sessionKey != null) {
            this.simpleArg("wpSessionKey", sessionKey);
        }
        if (watchThis) {
            this.simpleArg("wpWatchthis", "true");
        }
        this.simpleArg("wpUploadAffirm", "1");
        this.responseHandler(302, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                FileUploadAction.this.logger.info("upload successful");
                if (data.responseBody.trim().length() != 0) {
                    FileUploadAction.this.logger.warn("weird, store returned: " + data.statusLine + "\n" + data.responseBody);
                }
                FileUploadAction.this.uploaded = FileUploadAction.this.urlManager.anyURLToLocation(data.redirect);
                if (FileUploadAction.this.uploaded == null) {
                    throw new UnexpectedAnswerException("upload not successful, could not find target location").addFactoid("status", data.statusLine);
                }
                return true;
            }
        });
        this.responseMessageHandler(200, "successfulupload", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                FileUploadAction.this.logger.info("upload successful");
                Source source = JerichoUtil.createSource(data.responseBody, FileUploadAction.this.logger);
                String newTitle = null;
                List aTags = source.findAllStartTags("a");
                for (StartTag aTag : aTags) {
                    Attribute titleAttr;
                    Attribute classAttr;
                    Attributes attrs = aTag.getAttributes();
                    if (attrs == null || (classAttr = attrs.get("class")) == null || !"internal".equals(classAttr.getValue()) || (titleAttr = attrs.get("title")) == null) continue;
                    newTitle = titleAttr.getValue();
                    break;
                }
                if (newTitle == null) {
                    FileUploadAction.this.logger.warn("successfulupload without a name");
                    newTitle = title;
                }
                FileUploadAction.this.uploaded = FileUploadAction.this.site.location(6, newTitle);
                return true;
            }
        });
        this.responseMessageHandler(200, "uploadnologintext", new UploadForbiddenHandler("cannot upload without being logged in"));
        if (this.messageAvailable("badfiletype")) {
            this.responseMessageHandler(200, "badfiletype", new UploadForbiddenHandler("uploading this type of file is forbidden"));
        }
        this.responseMessageHandler(200, "badfilename", new UploadForbiddenHandler("uploading a file with this name is forbidden"));
        this.responseMessageHandler(200, "largefileserver", new UploadForbiddenHandler("uploading this file exceeds the hard file size limit"));
        this.responseMessageHandler(200, "uploadscripted", new UploadForbiddenHandler("uploading this file is forbidden, it seems to contain a script"));
        this.responseMessageHandler(200, "uploadvirus", new UploadForbiddenHandler("uploading this file is forbidden, it seems to contain a virus"));
        this.responseMessageHandler(200, "uploadcorrupt", new UploadForbiddenHandler("uploading this file is forbidden, it may be corrupted or have the wrong ending"));
        this.responseMessageHandler(200, "uploaddisabled", new UploadForbiddenHandler("uploading files is disabled"));
        if (this.messageAvailable("filetype-badmime")) {
            this.responseMessageHandler(200, "filetype-badmime", new UploadForbiddenHandler("uploading a file with this MIME-type is forbidden"));
        }
        if (this.messageAvailable("filetype-badtype")) {
            this.responseMessageHandler(200, "filetype-badtype", new UploadForbiddenHandler("uploading a file with this file format is forbidden"));
        }
        if (this.messageAvailable("filetype-missing")) {
            this.responseMessageHandler(200, "filetype-missing", new UploadForbiddenHandler("uploading a file without a type extension is forbidden"));
        }
        this.responseMessageHandler(200, "fileexists", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                if (FileUploadAction.this.uploadCallback == null) {
                    throw new UploadFileExistsException("upload warning: fileexists");
                }
                ParsedUploadWarning warning = FileUploadAction.this.parsedUploadWarning(data.responseBody);
                if (FileUploadAction.this.uploadCallback.ignoreFileexists()) {
                    FileUploadAction.this.logger.debug("upload incomplete, fileexists: overwriting");
                    FileUploadAction.this.uploaded = FileUploadAction.this.retry(title, true, warning.sessionKey);
                    return true;
                }
                String ersatzTitle = FileUploadAction.this.uploadCallback.renameFileexists();
                if (ersatzTitle != null) {
                    FileUploadAction.this.logger.debug("upload incomplete, fileexists: renamed to " + ersatzTitle);
                    FileUploadAction.this.uploaded = FileUploadAction.this.retry(ersatzTitle, false, warning.sessionKey);
                    return true;
                }
                throw new UploadFileExistsException("upload warning: fileexists");
            }
        });
        this.responseMessageHandler(200, "filewasdeleted", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                if (FileUploadAction.this.uploadCallback == null) {
                    throw new UploadFileWasDeletedException("upload warning: filewasdeleted");
                }
                ParsedUploadWarning warning = FileUploadAction.this.parsedUploadWarning(data.responseBody);
                if (FileUploadAction.this.uploadCallback.ignoreFilewasdeleted()) {
                    FileUploadAction.this.logger.debug("upload incomplete, filewasdeleted");
                    FileUploadAction.this.uploaded = FileUploadAction.this.retry(title, true, warning.sessionKey);
                    return true;
                }
                throw new UploadFileWasDeletedException("upload warning: filewasdeleted");
            }
        });
        this.responseMessageHandler(200, "large-file", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                if (FileUploadAction.this.uploadCallback == null) {
                    throw new UploadFileLargeException("upload warning: large-file");
                }
                ParsedUploadWarning warning = FileUploadAction.this.parsedUploadWarning(data.responseBody);
                if (FileUploadAction.this.uploadCallback.ignoreLargefile()) {
                    FileUploadAction.this.logger.debug("upload incomplete, large-file");
                    FileUploadAction.this.uploaded = FileUploadAction.this.retry(title, true, warning.sessionKey);
                    return true;
                }
                throw new UploadFileLargeException("upload warning: large-file");
            }
        });
    }

    @Override
    protected HttpMethod createRequest(String requestURL, Map<String, String> requestArgs) {
        if (this.file != null) {
            return this.createMultipartPostMethod(requestURL, requestArgs, "wpUploadFile", this.file, this.progressListener);
        }
        return super.createRequest(requestURL, requestArgs);
    }

    @Override
    protected String fetchURL(String fetchTitle, Map<String, String> fetchArgs) throws UnsupportedURLException {
        return this.urlManager.readURL(fetchTitle, fetchArgs);
    }

    private ParsedUploadWarning parsedUploadWarning(String responseBody) throws MediaWikiException {
        try {
            return new ParsedUploadWarning(JerichoUtil.createSource(responseBody, this.logger));
        }
        catch (IllegalFormException e) {
            Location errorLocation = this.site.location(this.title);
            throw new UnexpectedAnswerException("cannot parse uploadwarning", e).addFactoid("location", errorLocation);
        }
    }

    private Location retry(String title_, boolean ignoreWarning_, String sessionKey_) throws MediaWikiException {
        FileUploadAction action = new FileUploadAction(this.mediaWiki, this.connection, title_, this.description, null, ignoreWarning_, this.watchThis, sessionKey_, this.progressListener, this.uploadCallback);
        action.execute();
        return action.getUploaded();
    }

    private static class UploadForbiddenHandler
    implements ResponseHandler {
        private String text;

        public UploadForbiddenHandler(String text) {
            this.text = text;
        }

        public boolean handle(ResponseData data) throws MediaWikiException {
            throw new UploadForbiddenException(this.text);
        }
    }
}

