/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.psammead.util.DebugUtil;
import net.psammead.util.reflect.Assignability;
import net.psammead.util.reflect.ReflectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static Object array(String className, Object[] values) throws ReflectException {
        return ReflectUtil.array(ReflectUtil.clazz(className), values);
    }

    public static Object array(Class<?> clazz, Object[] values) throws ReflectException {
        int size = values.length;
        Object out = Array.newInstance(clazz, size);
        try {
            System.arraycopy(values, 0, out, 0, size);
        }
        catch (ArrayStoreException e) {
            throw new ReflectException(e);
        }
        return out;
    }

    public static Object object(String className, Object[] arguments) throws ReflectException {
        return ReflectUtil.object(ReflectUtil.clazz(className), arguments);
    }

    public static Object object(Class<?> clazz, Object[] arguments) throws ReflectException {
        try {
            return ReflectUtil.constructor(clazz, ReflectUtil.types(arguments)).newInstance(arguments);
        }
        catch (InstantiationException e) {
            throw new ReflectException(e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    public static Object call(Object target, String methodName, Object[] arguments) throws ReflectException {
        Method method = ReflectUtil.method(target.getClass(), methodName, ReflectUtil.types(arguments));
        try {
            return method.invoke(target, arguments);
        }
        catch (IllegalAccessException e) {
            throw new ReflectException(e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    public static Class<?> clazz(String name) throws ReflectException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectException(e);
        }
    }

    public static Class<?>[] types(Object[] values) {
        int size = values.length;
        Class[] out = new Class[size];
        for (int i = 0; i < size; ++i) {
            Object value = values[i];
            out[i] = value != null ? value.getClass() : null;
        }
        return out;
    }

    public static Constructor<?> constructor(Class<?> clazz, Class<?>[] argTypes) throws ReflectException {
        Constructor<?>[] constructors;
        ArrayList maybe = new ArrayList();
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            Assignability assignability = ReflectUtil.assignable(argTypes, paramTypes);
            if (assignability == Assignability.exact) {
                return constructor;
            }
            if (!assignability.betterThan(Assignability.incompatible)) continue;
            maybe.add(constructor);
        }
        int possibilities = maybe.size();
        if (possibilities == 1) {
            return (Constructor)maybe.get(0);
        }
        if (possibilities == 0) {
            throw new ReflectException("cannot find constructor for " + ReflectUtil.description(clazz, DebugUtil.shortType(clazz), argTypes));
        }
        StringBuilder b = new StringBuilder("found ambiguous constructors for " + ReflectUtil.description(clazz, DebugUtil.shortType(clazz), argTypes));
        for (Constructor constructor : maybe) {
            b.append("\n").append(constructor.toString());
        }
        throw new ReflectException(b.toString());
    }

    public static Method method(Class<?> clazz, String name, Class<?>[] argTypes) throws ReflectException {
        Method[] methods;
        ArrayList<Method> maybe = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (!name.equals(method.getName())) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            Assignability assignability = ReflectUtil.assignable(argTypes, paramTypes);
            if (assignability == Assignability.exact) {
                return method;
            }
            if (!assignability.betterThan(Assignability.incompatible)) continue;
            maybe.add(method);
        }
        int possibilities = maybe.size();
        if (possibilities == 1) {
            return (Method)maybe.get(0);
        }
        if (possibilities == 0) {
            throw new ReflectException("cannot find method for " + ReflectUtil.description(clazz, name, argTypes));
        }
        StringBuilder b = new StringBuilder("found ambiguous methods for " + ReflectUtil.description(clazz, name, argTypes));
        for (Method method : maybe) {
            b.append("\n").append(method.toString());
        }
        throw new ReflectException(b.toString());
    }

    public static Field field(Class<?> clazz, String name) throws ReflectException {
        try {
            return clazz.getField(name);
        }
        catch (SecurityException e) {
            throw new ReflectException(e);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectException(e);
        }
    }

    public static Assignability assignable(Class<?>[] values, Class<?>[] targets) {
        if (values.length != targets.length) {
            return Assignability.incompatible;
        }
        Assignability max = Assignability.exact;
        for (int i = 0; i < values.length; ++i) {
            Assignability here = ReflectUtil.assignable(values[i], targets[i]);
            if (!max.betterThan(here)) continue;
            max = here;
        }
        return max;
    }

    public static Assignability assignable(Class<?> value, Class<?> target) {
        if (value == target) {
            return Assignability.exact;
        }
        if (value == null) {
            return Assignability.nullref;
        }
        if (target.isAssignableFrom(value)) {
            return Assignability.assignable;
        }
        if (ReflectUtil.coercable(value, target)) {
            return Assignability.coercable;
        }
        return Assignability.incompatible;
    }

    public static boolean coercable(Class<?> value, Class<?> target) {
        return value == Character.TYPE && target == Character.class || value == Character.class && target == Character.TYPE || value == Byte.TYPE && target == Byte.class || value == Byte.class && target == Byte.TYPE || value == Short.TYPE && target == Short.class || value == Short.class && target == Short.TYPE || value == Integer.TYPE && target == Integer.class || value == Integer.class && target == Integer.TYPE || value == Long.TYPE && target == Long.class || value == Long.class && target == Long.TYPE || value == Boolean.TYPE && target == Boolean.class || value == Boolean.class && target == Boolean.TYPE;
    }

    public static String description(Class<?> clazz, String method, Class<?>[] argTypes) {
        StringBuilder out = new StringBuilder();
        out.append("class: ").append(clazz.getName()).append(", ");
        out.append("method: ").append(method).append(", ");
        out.append("args: [");
        boolean first = true;
        for (Class<?> argType : argTypes) {
            if (!first) {
                out.append(", ");
            }
            first = false;
            if (argType != null) {
                out.append(argType.getName());
                continue;
            }
            out.append("<null>");
        }
        out.append("]");
        return out.toString();
    }
}

