/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.json;

import java.util.ArrayList;
import java.util.HashMap;
import net.psammead.util.JavaLiteral;
import net.psammead.util.StringUtil;
import net.psammead.util.json.JSONDecodeException;

public final class JSONDecoder {
    private static final int NO_CHAR = -1;
    private final String text;
    private int offset;

    public static Object decode(String text) throws JSONDecodeException {
        return new JSONDecoder(text).decode();
    }

    private JSONDecoder(String text) {
        this.text = text;
        this.offset = 0;
    }

    private Object decode() throws JSONDecodeException {
        Object value = this.decodeNext();
        this.ws();
        if (!this.finished()) {
            throw this.expected("end of input");
        }
        return value;
    }

    private Object decodeNext() throws JSONDecodeException {
        boolean exp;
        this.ws();
        if (this.finished()) {
            throw this.expected("any char");
        }
        if (this.is("null")) {
            return null;
        }
        if (this.is("true")) {
            return true;
        }
        if (this.is("false")) {
            return false;
        }
        if (this.is('[')) {
            ArrayList<Object> out = new ArrayList<Object>();
            this.ws();
            if (this.is(']')) {
                return out;
            }
            do {
                Object val = this.decodeNext();
                out.add(val);
                this.ws();
            } while (this.is(','));
            if (this.is(']')) {
                return out;
            }
            throw this.expectedClass(",]");
        }
        if (this.is('{')) {
            HashMap<Object, Object> out = new HashMap<Object, Object>();
            this.ws();
            if (this.is('}')) {
                return out;
            }
            do {
                Object key;
                if (!((key = this.decodeNext()) instanceof String)) {
                    throw this.expected("string key");
                }
                this.ws();
                if (!this.is(':')) {
                    throw this.expectedClass(":");
                }
                Object val = this.decodeNext();
                out.put(key, val);
                this.ws();
            } while (this.is(','));
            if (this.is('}')) {
                return out;
            }
            throw this.expectedClass(",}");
        }
        if (this.is('\"')) {
            StringBuilder out = new StringBuilder();
            while (true) {
                if (this.is('\\')) {
                    if (this.finished()) {
                        throw this.expected("escape continuation");
                    }
                    if (this.is('\"')) {
                        out.append('\"');
                        continue;
                    }
                    if (this.is('\\')) {
                        out.append('\\');
                        continue;
                    }
                    if (this.is('/')) {
                        out.append('/');
                        continue;
                    }
                    if (this.is('t')) {
                        out.append('\t');
                        continue;
                    }
                    if (this.is('r')) {
                        out.append('\r');
                        continue;
                    }
                    if (this.is('n')) {
                        out.append('\n');
                        continue;
                    }
                    if (this.is('f')) {
                        out.append('\f');
                        continue;
                    }
                    if (this.is('b')) {
                        out.append('\b');
                        continue;
                    }
                    if (this.is('u')) {
                        if (this.offset + 4 > this.text.length()) {
                            throw this.expected("4 hex digits");
                        }
                        int before = this.offset;
                        this.offset += 4;
                        try {
                            out.append((char)Integer.parseInt(this.from(before), 16));
                        }
                        catch (NumberFormatException e) {
                            this.offset -= 4;
                            throw this.expected("4 hex digits");
                        }
                    }
                    throw this.expectedClass("\"\\/trnfbu");
                }
                if (this.is('\"')) {
                    return out.toString();
                }
                if (this.rng('\u0000', '\u001f')) {
                    --this.offset;
                    throw this.expected("no control character");
                }
                if (this.finished()) {
                    throw this.expected("more chars");
                }
                out.append((char)this.next());
                this.consume();
            }
        }
        int before = this.offset;
        this.is('-');
        if (!this.digits()) {
            throw this.expected("digits");
        }
        if (!this.is('.')) {
            return Long.parseLong(this.from(before));
        }
        if (!this.digits()) {
            throw this.expected("digits");
        }
        boolean bl = exp = this.is('e') || this.is('E');
        if (!exp) {
            return Double.parseDouble(this.from(before));
        }
        if (!this.is('+')) {
            this.is('-');
        }
        if (!this.digits()) {
            throw this.expected("digits");
        }
        return Double.parseDouble(this.from(before));
    }

    private JSONDecodeException expected(String what) {
        return new JSONDecodeException(this.text, this.offset, what);
    }

    private JSONDecodeException expectedClass(String charClass) {
        ArrayList<String> strs = new ArrayList<String>();
        for (char c : charClass.toCharArray()) {
            strs.add(JavaLiteral.encodeChar(c));
        }
        String what = StringUtil.join(strs, " or ");
        return new JSONDecodeException(this.text, this.offset, what);
    }

    private boolean digits() {
        int c;
        int before = this.offset;
        while (!this.finished() && (c = this.next()) >= 48 && c <= 57) {
            this.consume();
        }
        return this.offset != before;
    }

    private void ws() {
        int c;
        while (!(this.finished() || (c = this.next()) != 32 && c != 9 && c != 13 && c != 10)) {
            this.consume();
        }
    }

    private boolean rng(char start, char end) {
        if (this.finished()) {
            return false;
        }
        int c = this.next();
        if (c < start || c > end) {
            return false;
        }
        this.consume();
        return true;
    }

    private boolean is(char c) {
        if (this.finished()) {
            return false;
        }
        if (c != this.next()) {
            return false;
        }
        this.consume();
        return true;
    }

    private boolean is(String s) {
        int end = this.offset + s.length();
        if (end > this.text.length()) {
            return false;
        }
        if (!s.equals(this.text.substring(this.offset, end))) {
            return false;
        }
        this.offset = end;
        return true;
    }

    private String from(int before) {
        return this.text.substring(before, this.offset);
    }

    private int next() {
        if (this.finished()) {
            return -1;
        }
        return this.text.charAt(this.offset);
    }

    private void consume() {
        if (this.finished()) {
            throw new RuntimeException("already finished");
        }
        ++this.offset;
    }

    private boolean finished() {
        return this.offset == this.text.length();
    }
}

