/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.cache;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.psammead.util.Function;
import net.psammead.util.cache.BaseCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeakCache<S, T>
extends BaseCache<S, T> {
    private static final int CLEANUP_CYCLE = 1000;
    private final Map<S, WeakReference<T>> references = new HashMap<S, WeakReference<T>>();
    private int accessCount = 0;

    public WeakCache(Function<? super S, ? extends T> loader) {
        super(loader);
    }

    @Override
    public void clear() {
        this.references.clear();
    }

    @Override
    public T apply(S key) {
        this.maybeCleanup();
        WeakReference<T> reference = this.references.get(key);
        if (reference == null) {
            return this.load(key);
        }
        Object value = reference.get();
        if (value == null) {
            return this.load(key);
        }
        return value;
    }

    private T load(S key) {
        Object value = this.fetch(key);
        this.references.put(key, new WeakReference(value));
        return value;
    }

    private void maybeCleanup() {
        ++this.accessCount;
        if (this.accessCount < 1000) {
            return;
        }
        this.accessCount = 0;
        Iterator<Map.Entry<S, WeakReference<T>>> it = this.references.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<S, WeakReference<T>> entry = it.next();
            if (entry.getValue().get() != null) continue;
            it.remove();
        }
    }
}

