/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.io.File;
import java.io.IOException;
import net.psammead.util.Diff;
import net.psammead.util.IOUtil;

public final class StringDiff {
    private static final String LEFT_PREFIX = "< ";
    private static final String RIGHT_PREFIX = "> ";
    private static final String CHANGE_SEPARATOR = "---";
    private static final String NUMBER_SEPARATOR = ",";
    private static final String DELETE_OP = "d";
    private static final String APPEND_OP = "a";
    private static final String CHANGE_OP = "c";
    private static final String LINE_SEPARATOR = "\n";

    public static void main(String ... args) throws IOException {
        if (args.length != 3) {
            System.err.println("usage: StringDiff charset file1 file2");
            System.exit(1);
        }
        String left = IOUtil.readStringFromFile(new File(args[1]), args[0]);
        String right = IOUtil.readStringFromFile(new File(args[2]), args[0]);
        System.out.print(StringDiff.classic(left, right));
        System.out.flush();
    }

    private StringDiff() {
    }

    public static String classic(String left, String right) {
        Object[] leftLines = left.split(LINE_SEPARATOR);
        Object[] rightLines = right.split(LINE_SEPARATOR);
        Diff diff = new Diff(leftLines, rightLines);
        Diff.Change script = diff.diff2(false);
        StringBuilder out = new StringBuilder();
        Diff.Change hunk = script;
        while (hunk != null) {
            int deletes = hunk.deleted;
            int inserts = hunk.inserted;
            if (deletes != 0 || inserts != 0) {
                int i;
                int leftFirst = hunk.line0;
                int rightFirst = hunk.line1;
                int leftLast = hunk.line0 + deletes - 1;
                int rightLast = hunk.line1 + inserts - 1;
                if (deletes > 1) {
                    out.append(Integer.toString(leftFirst + 1)).append(NUMBER_SEPARATOR);
                }
                out.append(Integer.toString(leftLast + 1));
                if (inserts == 0) {
                    out.append(DELETE_OP);
                } else if (deletes == 0) {
                    out.append(APPEND_OP);
                } else {
                    out.append(CHANGE_OP);
                }
                if (inserts > 1) {
                    out.append(Integer.toString(rightFirst + 1)).append(NUMBER_SEPARATOR);
                }
                out.append(Integer.toString(rightLast + 1)).append(LINE_SEPARATOR);
                if (deletes != 0) {
                    for (i = leftFirst; i <= leftLast; ++i) {
                        out.append(LEFT_PREFIX).append((String)leftLines[i]).append(LINE_SEPARATOR);
                    }
                }
                if (inserts != 0 && deletes != 0) {
                    out.append(CHANGE_SEPARATOR).append(LINE_SEPARATOR);
                }
                if (inserts != 0) {
                    for (i = rightFirst; i <= rightLast; ++i) {
                        out.append(RIGHT_PREFIX).append((String)rightLines[i]).append(LINE_SEPARATOR);
                    }
                }
            }
            hunk = hunk.link;
        }
        return out.toString();
    }

    public static String sideBySide(String left, String right, String leftPrefix, String rightPrefix, String commonPrefix, String lineSeparator) {
        int line;
        Object[] leftLines = left.split(lineSeparator);
        Object[] rightLines = right.split(lineSeparator);
        Diff diff = new Diff(leftLines, rightLines);
        Diff.Change script = diff.diff2(false);
        StringBuilder out = new StringBuilder();
        int cursor = 0;
        Diff.Change hunk = script;
        while (hunk != null) {
            int leftPos = hunk.line0;
            int deletes = hunk.deleted;
            int rightPos = hunk.line1;
            int inserts = hunk.inserted;
            for (line = cursor; line < leftPos; ++line) {
                out.append(commonPrefix).append((String)leftLines[line]).append(lineSeparator);
            }
            for (line = leftPos; line < leftPos + deletes; ++line) {
                out.append(leftPrefix).append((String)leftLines[line]).append(lineSeparator);
            }
            for (line = rightPos; line < rightPos + inserts; ++line) {
                out.append(rightPrefix).append((String)rightLines[line]).append(lineSeparator);
            }
            cursor = leftPos + deletes;
            hunk = hunk.link;
        }
        for (line = cursor; line < leftLines.length; ++line) {
            out.append(commonPrefix).append((String)leftLines[line]).append(lineSeparator);
        }
        return out.toString();
    }

    public static String editScript(String left, String right) {
        Object[] file0 = left.split(LINE_SEPARATOR);
        Object[] file1 = right.split(LINE_SEPARATOR);
        Diff.Change change = new Diff(file0, file1).diff2(true);
        String lf = LINE_SEPARATOR;
        StringBuilder out = new StringBuilder();
        while (change != null) {
            if (change.deleted != 0 || change.inserted != 0) {
                String numberRange;
                int last0 = change.line0 + change.deleted - 1;
                int last1 = change.line1 + change.inserted - 1;
                String string = numberRange = last0 > change.line0 ? "" + (change.line0 + 1) + ',' + (last0 + 1) : "" + (last0 + 1);
                char changeLetter = change.inserted == 0 ? (char)'d' : (change.deleted == 0 ? (char)'a' : 'c');
                out.append(numberRange).append(changeLetter).append(LINE_SEPARATOR);
                if (change.inserted != 0) {
                    boolean inserting = true;
                    for (int i = change.line1; i <= last1; ++i) {
                        if (!inserting) {
                            out.append(i - change.line1 + change.line0 + APPEND_OP).append(LINE_SEPARATOR);
                        }
                        inserting = true;
                        if (".".equals(file1[i])) {
                            out.append("..").append(LINE_SEPARATOR);
                            out.append(".").append(LINE_SEPARATOR);
                            out.append(i - change.line1 + change.line0 + 1 + "s/^\\.\\././").append(LINE_SEPARATOR);
                            inserting = false;
                            continue;
                        }
                        out.append(((String)file1[i]).toString()).append(LINE_SEPARATOR);
                    }
                    if (inserting) {
                        out.append(".").append(LINE_SEPARATOR);
                    }
                }
            }
            change = change.link;
        }
        return out.toString();
    }
}

