package net.psammead.mwapi.yurik.json;

import java.util.Map;

public class MapEntry implements JSONConverter {
	final String key;
	private final JSONConverter	sub;

	public MapEntry(String key, JSONConverter sub) {
		this.key	= key;
		this.sub	= sub;
	}

	@SuppressWarnings("unchecked")
	public Object convert(JSONConverterContext ctx, Object o) throws JSONConverterException {
		if (!(o instanceof Map))	throw new JSONConverterException("expected a Map: " + o);
		Map	data	= (Map)o;

		Object	value	= data.get(key);
		return sub.convert(ctx, value);
	}
}
