package net.psammead.mwapi.scrapper;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import net.psammead.util.IOUtil;
import net.psammead.util.Logger;
import net.psammead.util.Throttle;

public class HttpUtilCommons implements HttpUtil {
	// TODO useless. this is a copy of HttpUtilJDK
	private static final Logger log	= new Logger(HttpUtilCommons.class);
	
	private Throttle throttle	= new Throttle(100);	// 10 requests per second

	/** download a page and return its charset and body */
	public HttpResult download(URL url) throws IOException {
		try { throttle.gate(); } catch (InterruptedException e) { throw new IOException("download aborted"); }
		log.info("GET " + url);
		
		HttpURLConnection	connection	= null;
		try {
			connection	= (HttpURLConnection)url.openConnection();
			connection.setRequestProperty ("User-agent", "scrapper/1.0");
			connection.setDoInput(true);
			connection.setUseCaches(false);
			connection.setRequestMethod("GET");
			connection.setAllowUserInteraction(false);
			connection.connect();
			
			String	type	= connection.getContentType();
			if (type == null)	throw new RuntimeException("no contenttype in: " + url);
			String	charset	= charset(type);
			
			String	body	= IOUtil.readStringFromStream(connection.getInputStream(), charset);
			return new HttpResult(charset, body);
		}
		finally {
			if (connection != null) {
				try { connection.disconnect(); }
				catch (Exception e) { e.printStackTrace(); }
			}
		}
	}
	
	private String charset(String contentType) {
		int	pos		= contentType.indexOf("charset=");
		if (pos >= 0) {
			String charset	= contentType.substring(pos+"charset=".length());
			int pos2	= charset.indexOf(";");
			if (pos2 >= 0) {
				charset	= charset.substring(0,pos2);
			}
			return charset;
		}
		else if ("text/xml".equals(contentType)){
			return "utf-8";
		}
		else {
			return "iso-8859-1";
		}
	}
	
	/** finds out where an URL redirects to */
	public String redirectsTo(URL url) throws IOException {
		try { throttle.gate(); } catch (InterruptedException e) { throw new IOException("download aborted"); }
		log.info("GET " + url);
		
		HttpURLConnection connection = null;
		try {
			connection	= (HttpURLConnection)url.openConnection();
			connection.setRequestProperty("User-agent", "scrapper/1.0");
			connection.setDoInput(true);
			connection.setUseCaches(false);
			connection.setRequestMethod("GET");
			connection.setAllowUserInteraction(false);
			
			connection.setInstanceFollowRedirects(false);
			
			int	code	= connection.getResponseCode();
			if (code != HttpURLConnection.HTTP_MOVED_TEMP 
			&& code != HttpURLConnection.HTTP_MOVED_PERM) {
			// no redirect? this is an english wiki.
				return null;
			}
			
			String location	= connection.getHeaderField("location");
			return location;
		}
		finally {
			if (connection != null) {
				try {
					connection.disconnect();
				}
				catch (Exception e) {
					log.warn("closing connection failed", e);
				}
			}
		}
	}
	
	public void useSystemProxy() throws MalformedURLException {
		String proxy = System.getenv("http_proxy");
		if (proxy == null)	return;
		URL url	= new URL(proxy);
		useProxy(url.getHost(), url.getPort());
	}
	
	public void useProxy(String host, int port) {
		// new vars
		System.setProperty("http.proxyHost", host);
		System.setProperty("http.proxyPort", ""+port);

		/*
		/ old vars
		proxySet
		proxyHost
		proxyPort
		 
		// other vars
		http.nonProxyHosts	
		ftp.proxyHost		
		ftp.proxyPort		80
		ftp.nonProxyHosts	
		socksProxyHost
		socksProxyPort		1080
		*/
	}
}
