package net.psammead.util;

import java.util.IdentityHashMap;
import java.util.Map;

/** assigns long ids to arbitrary Objects */
public final class IdGenerator {
	private final	Map<Object,Long> map;
	private long	nextId;
	
	public IdGenerator() {
		map		= new IdentityHashMap<Object, Long>();
		nextId	= 0;
	}
	
	public synchronized long id(Object object) {
		Long	id	= map.get(object);
		if (id == null) {
			id	= nextId;
			nextId++;
			map.put(object, id);
		}
		return id;
	}
}
