/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.connection;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.psammead.mwapi.Location;
import net.psammead.mwapi.config.Site;
import net.psammead.mwapi.connection.TitleUtil;
import net.psammead.mwapi.ui.UnsupportedFeatureException;
import net.psammead.mwapi.ui.UnsupportedURLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLManager {
    private Site site;

    public URLManager(Site site) {
        this.site = site;
    }

    public URL locationToReadURL(Location location) throws UnsupportedURLException {
        HashMap<String, String> args = new HashMap<String, String>();
        String url = this.readURL(location.title, args);
        url = url + this.queryArgs(args);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new UnsupportedURLException("malformed URL", e);
        }
    }

    public Location anyURLToLocation(URL url) throws UnsupportedURLException {
        Location prettyLoc;
        Location rawLoc = this.site.rawPath != null ? this.urlToLocation(url, this.site.rawPath, "\\?title=([^&]*).*") : null;
        Location location = prettyLoc = this.site.prettyPath != null ? this.urlToLocation(url, this.site.prettyPath, "([^?]*).*") : null;
        if (rawLoc != null && prettyLoc != null) {
            return this.site.prettyPath.length() > this.site.rawPath.length() ? prettyLoc : rawLoc;
        }
        if (rawLoc != null) {
            return rawLoc;
        }
        if (prettyLoc != null) {
            return prettyLoc;
        }
        return null;
    }

    public String actionURL(String title, Map<String, String> args) throws UnsupportedURLException {
        if (this.site.rawPath != null) {
            args.put("title", title);
            return this.site.protocol + this.site.hostName + this.site.rawPath;
        }
        if (this.site.prettyPath != null) {
            return this.site.protocol + this.site.hostName + this.site.prettyPath + TitleUtil.encodeTitle(title, this.site.charSet);
        }
        throw new UnsupportedURLException("neither readPath nor actionPath available");
    }

    public String readURL(String title, Map<String, String> args) throws UnsupportedURLException {
        if (this.site.prettyPath != null) {
            return this.site.protocol + this.site.hostName + this.site.prettyPath + TitleUtil.encodeTitle(title, this.site.charSet);
        }
        if (this.site.rawPath != null) {
            args.put("title", title);
            return this.site.protocol + this.site.hostName + this.site.rawPath;
        }
        throw new UnsupportedURLException("neither readPath nor actionPath available");
    }

    public String apiURL() throws UnsupportedFeatureException {
        if (this.site.apiPath == null) {
            throw new UnsupportedFeatureException("api.php is not supported on site: " + this.site);
        }
        return this.site.protocol + this.site.hostName + this.site.apiPath;
    }

    private String queryArgs(Map<String, ?> args) throws UnsupportedURLException {
        try {
            String query = "";
            String sep = "?";
            for (String key : args.keySet()) {
                String value = "" + args.get(key);
                query = query + sep + URLEncoder.encode(key, this.site.charSet) + "=" + URLEncoder.encode(value, this.site.charSet);
                sep = "&";
            }
            return query;
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedURLException("encoding problem", e);
        }
    }

    private Location urlToLocation(URL url, String path, String extractRE) throws UnsupportedURLException {
        String prefix;
        String raw = url.toExternalForm();
        if (!raw.startsWith(prefix = this.site.protocol + this.site.hostName + path)) {
            return null;
        }
        String rest = raw.substring(prefix.length());
        Pattern pattern = Pattern.compile(extractRE);
        Matcher matcher = pattern.matcher(rest);
        if (!matcher.matches()) {
            return null;
        }
        String extracted = matcher.group(1);
        if (extracted.length() == 0) {
            return null;
        }
        return this.site.location(TitleUtil.decodeTitle(extracted, this.site.charSet));
    }
}

