/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.psammead.mwapi.Location;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.NameSpace;
import net.psammead.mwapi.config.Site;
import net.psammead.mwapi.connection.ConfigException;
import net.psammead.mwapi.connection.ConfigManager;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.connection.LocationManager;
import net.psammead.mwapi.connection.URLManager;
import net.psammead.mwapi.net.NonProxyConnectionManager;
import net.psammead.mwapi.ui.MoveCallback;
import net.psammead.mwapi.ui.Page;
import net.psammead.mwapi.ui.ProgressCallback;
import net.psammead.mwapi.ui.UnsupportedFeatureException;
import net.psammead.mwapi.ui.UnsupportedURLException;
import net.psammead.mwapi.ui.UnsupportedWikiException;
import net.psammead.mwapi.ui.UploadCallback;
import net.psammead.mwapi.ui.Uploaded;
import net.psammead.mwapi.ui.action.FileURLAction;
import net.psammead.mwapi.ui.action.FileUploadAction;
import net.psammead.mwapi.ui.action.PageDeleteAction;
import net.psammead.mwapi.ui.action.PageLoadAction;
import net.psammead.mwapi.ui.action.PageMoveAction;
import net.psammead.mwapi.ui.action.PageProtectAction;
import net.psammead.mwapi.ui.action.PageStoreAction;
import net.psammead.mwapi.ui.action.PageWatchAction;
import net.psammead.mwapi.ui.action.UserBlockAction;
import net.psammead.mwapi.ui.action.UserLoginAction;
import net.psammead.mwapi.ui.action.UserLogoutAction;
import net.psammead.mwapi.yurik.YurikAPI;
import net.psammead.mwapi.yurik.data.list.AllLinksResult;
import net.psammead.mwapi.yurik.data.list.AllPagesResult;
import net.psammead.mwapi.yurik.data.list.AllUsersResult;
import net.psammead.mwapi.yurik.data.list.BackLinksResult;
import net.psammead.mwapi.yurik.data.list.CategoryMembersResult;
import net.psammead.mwapi.yurik.data.list.EmbeddedInResult;
import net.psammead.mwapi.yurik.data.list.ExtUrlUsageResult;
import net.psammead.mwapi.yurik.data.list.ImageUsageResult;
import net.psammead.mwapi.yurik.data.list.LogEventsResult;
import net.psammead.mwapi.yurik.data.list.RecentChangesResult;
import net.psammead.mwapi.yurik.data.list.UserContribsResult;
import net.psammead.mwapi.yurik.data.list.WatchListResult;
import net.psammead.mwapi.yurik.data.prop.CategoriesResult;
import net.psammead.mwapi.yurik.data.prop.ExtLinksResult;
import net.psammead.mwapi.yurik.data.prop.ImageInfoResult;
import net.psammead.mwapi.yurik.data.prop.ImagesResult;
import net.psammead.mwapi.yurik.data.prop.InfoResult;
import net.psammead.mwapi.yurik.data.prop.LangLinksResult;
import net.psammead.mwapi.yurik.data.prop.LinksResult;
import net.psammead.mwapi.yurik.data.prop.RevisionsResult;
import net.psammead.mwapi.yurik.data.prop.TemplatesResult;
import net.psammead.util.Destroyable;
import net.psammead.util.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaWiki
implements Destroyable {
    public static final String DEFAULT_USER_AGENT = "mwapi/0.0";
    public static final String COOKIE_POLICY = "rfc2109";
    private Logger logger = new Logger(MediaWiki.class);
    private ConfigManager configManager = new ConfigManager();
    private LocationManager locationManager = new LocationManager(this.configManager);
    private NonProxyConnectionManager manager;
    private HttpClient client;
    private String userAgent = "mwapi/0.0";
    private Map<String, Connection> connections = new HashMap<String, Connection>();

    public MediaWiki() throws ConfigException {
        this.manager = new NonProxyConnectionManager();
        HttpConnectionManagerParams managerParams = this.manager.getParams();
        managerParams.setDefaultMaxConnectionsPerHost(6);
        managerParams.setMaxTotalConnections(18);
        managerParams.setStaleCheckingEnabled(true);
        this.client = new HttpClient((HttpConnectionManager)this.manager);
    }

    public void destroy() {
        this.manager.shutdown();
    }

    public List<String> supportedWikis() {
        return this.configManager.getSupportedWikiNames();
    }

    public String loadFamily(URL familyDescriptor) throws ConfigException {
        this.connections.clear();
        return this.configManager.loadFamily((URL)familyDescriptor).name;
    }

    public Location location(String wiki, String link) throws UnsupportedWikiException {
        return this.relativeLocation(new Location(wiki, "."), link);
    }

    public Location absoluteLocation(String link) throws UnsupportedWikiException {
        return this.locationManager.absoluteLocation(link);
    }

    public Location relativeLocation(Location baseLocation, String link) throws UnsupportedWikiException {
        return this.locationManager.relativeLocation(baseLocation, link);
    }

    public Location regularPageFor(Location location) throws UnsupportedWikiException {
        return this.locationManager.regularPageFor(location);
    }

    public Location discussionPageFor(Location location) throws UnsupportedWikiException {
        return this.locationManager.discussionPageFor(location);
    }

    public Location toggleDiscussion(Location location) throws UnsupportedWikiException {
        return this.locationManager.toggleDiscussion(location);
    }

    public Location homeLocation(String wiki) throws UnsupportedWikiException {
        Site site = this.configManager.getSite(wiki);
        Connection connection = this.connection(wiki);
        if (!connection.isLoggedIn()) {
            return null;
        }
        NameSpace userNS = site.nameSpace(2);
        String userName = connection.getUserName();
        String title = userNS.addTo(userName);
        return new Location(wiki, title);
    }

    public Location urlToLocation(URL url) throws UnsupportedWikiException, UnsupportedURLException {
        List<String> supported = this.configManager.getSupportedWikiNames();
        for (String wiki : supported) {
            URLManager urlManager = this.connection((String)wiki).urlManager;
            Location location = urlManager.anyURLToLocation(url);
            if (location == null) continue;
            return location;
        }
        throw new UnsupportedURLException("url " + url + " does not belong to a known wiki");
    }

    public URL locationToURL(Location location) throws UnsupportedURLException, UnsupportedWikiException {
        URLManager urlManager = this.connection((String)location.wiki).urlManager;
        return urlManager.locationToReadURL(location);
    }

    public NameSpace nameSpace(String wiki, int index) throws UnsupportedWikiException {
        return this.configManager.getSite(wiki).nameSpace(index);
    }

    public NameSpace nameSpaceFor(Location location) throws UnsupportedWikiException {
        return this.configManager.getSite(location.wiki).nameSpaceForTitle(location.title);
    }

    public String userName(String wiki) throws UnsupportedWikiException {
        Connection connection = this.connection(wiki);
        return connection.getUserName();
    }

    public boolean loggedIn(String wiki) throws UnsupportedWikiException {
        Connection connection = this.connection(wiki);
        return connection.isLoggedIn();
    }

    public Page load(Location location) throws MediaWikiException {
        return this.loadOld(location, null);
    }

    public Page loadOld(Location location, String oldid) throws MediaWikiException {
        Connection connection = this.connection(location.wiki);
        PageLoadAction action = new PageLoadAction(this, connection, location.title, oldid);
        action.execute();
        return action.getPage();
    }

    public Page store(Page page, String summary, boolean minorEdit) throws MediaWikiException {
        Connection connection = this.connection(page.location.wiki);
        PageStoreAction action = new PageStoreAction(this, connection, page, summary, minorEdit);
        action.execute();
        return action.getConflict();
    }

    public Uploaded upload(String wiki, String title, String description, File file, boolean watchThis, ProgressCallback progressListener, UploadCallback callback) throws MediaWikiException {
        Connection connection = this.connection(wiki);
        FileUploadAction action = new FileUploadAction(this, connection, title, description, file, watchThis, progressListener, callback);
        action.execute();
        return new Uploaded(action.getUploaded());
    }

    public void watched(Location location, boolean watch) throws MediaWikiException {
        Connection connection = this.connection(location.wiki);
        PageWatchAction action = new PageWatchAction(this, connection, location.title, watch);
        action.execute();
    }

    public void delete(Location location, String reason) throws MediaWikiException {
        Connection connection = this.connection(location.wiki);
        PageDeleteAction action = new PageDeleteAction(this, connection, location.title, reason);
        action.execute();
    }

    public void protect(Location location, String levelEdit, String levelMove, boolean cascade, String expiry, String reason) throws MediaWikiException {
        Connection connection = this.connection(location.wiki);
        PageProtectAction action = new PageProtectAction(this, connection, location.title, levelEdit, levelMove, cascade, expiry, reason);
        action.execute();
    }

    public void block(String wiki, String user, String duration, String reason, boolean anonOnly, boolean createAccount, boolean enableAutoblock, boolean emailBan) throws MediaWikiException {
        Connection connection = this.connection(wiki);
        UserBlockAction action = new UserBlockAction(this, connection, user, duration, reason, anonOnly, createAccount, enableAutoblock, emailBan);
        action.execute();
    }

    public void move(String wiki, String oldTitle, String newTitle, String reason, MoveCallback moveCallback) throws MediaWikiException {
        Connection connection = this.connection(wiki);
        PageMoveAction action = new PageMoveAction(this, connection, oldTitle, newTitle, reason, moveCallback);
        action.execute();
    }

    public URL fileURL(String wiki, String name) throws MediaWikiException {
        Connection connection = this.connection(wiki);
        FileURLAction action = new FileURLAction(this, connection, name);
        action.execute();
        return action.getURL();
    }

    public boolean login(String wiki, String user, String passwd, boolean remember) throws MediaWikiException {
        Connection connection = this.connection(wiki);
        UserLoginAction action = new UserLoginAction(this, connection, user, passwd, remember);
        action.execute();
        return action.isSuccess();
    }

    public boolean logout(String wiki) throws MediaWikiException {
        Connection connection = this.connection(wiki);
        UserLogoutAction action = new UserLogoutAction(this, connection);
        action.execute();
        return action.isSuccess();
    }

    public void logoutAll() throws MediaWikiException {
        for (Connection connection : this.connections.values()) {
            if (!connection.isLoggedIn()) continue;
            UserLogoutAction action = new UserLogoutAction(this, connection);
            action.execute();
        }
    }

    public boolean yurikApiSupported(String wiki) throws UnsupportedWikiException {
        return this.connection((String)wiki).site.apiPath != null;
    }

    private YurikAPI yurikAPI(String wiki) throws UnsupportedFeatureException, UnsupportedWikiException {
        Connection connection = this.connection(wiki);
        return new YurikAPI(this.getLogger(), connection.client, connection.throttle, connection.urlManager.apiURL(), this.getUserAgent(), connection.site.wiki, connection.site.charSet);
    }

    public CategoriesResult categories(Location location) throws MediaWikiException {
        return this.yurikAPI(location.wiki).categories(location.title);
    }

    public ExtLinksResult extLinks(Location location) throws MediaWikiException {
        return this.yurikAPI(location.wiki).extLinks(location.title);
    }

    public ImageInfoResult imageInfo(Location location) throws MediaWikiException {
        return this.yurikAPI(location.wiki).imageInfo(location.title);
    }

    public ImagesResult images(Location location) throws MediaWikiException {
        return this.yurikAPI(location.wiki).images(location.title);
    }

    public InfoResult info(Location location) throws MediaWikiException {
        return this.yurikAPI(location.wiki).info(location.title);
    }

    public LangLinksResult langLinks(Location location) throws MediaWikiException {
        return this.yurikAPI(location.wiki).langLinks(location.title);
    }

    public LinksResult links(Location location, List<NameSpace> nameSpaces) throws MediaWikiException {
        return this.yurikAPI(location.wiki).links(location.title, nameSpaces);
    }

    public RevisionsResult revisions(Location location, Long startId, Long endId, Date start, Date end, boolean newer, String user, String excludeUser, int limit) throws MediaWikiException {
        return this.yurikAPI(location.wiki).revisions(location.title, startId, endId, start, end, newer, user, excludeUser, limit);
    }

    public TemplatesResult templates(Location location, List<NameSpace> nameSpaces) throws MediaWikiException {
        return this.yurikAPI(location.wiki).templates(location.title, nameSpaces);
    }

    public AllPagesResult allPages(String wiki, String from, String prefix, List<NameSpace> nameSpaces, String filterRedir, int limit) throws MediaWikiException {
        return this.yurikAPI(wiki).allPages(from, prefix, nameSpaces, filterRedir, limit);
    }

    public AllLinksResult allLinks(String wiki, String from, String prefix, List<NameSpace> nameSpaces, int limit) throws MediaWikiException {
        return this.yurikAPI(wiki).allLinks(from, prefix, nameSpaces, limit);
    }

    public AllUsersResult allUsers(String wiki, String from, String prefix, List<NameSpace> nameSpaces, String group, int limit) throws MediaWikiException {
        return this.yurikAPI(wiki).allUsers(from, prefix, nameSpaces, group, limit);
    }

    public UserContribsResult userContribs(String wiki, String user, List<NameSpace> nameSpaces, Date start, Date end, boolean newer, int limit) throws MediaWikiException {
        return this.yurikAPI(wiki).userContribs(user, nameSpaces, start, end, newer, limit);
    }

    public CategoryMembersResult categoryMembers(String wiki, String category, List<NameSpace> nameSpaces, int limit, String continueKey) throws MediaWikiException {
        return this.yurikAPI(wiki).categoryMembers(category, nameSpaces, limit, continueKey);
    }

    public BackLinksResult backLinks(Location location, List<NameSpace> nameSpaces, boolean redirect, int limit, String continueKey) throws MediaWikiException {
        return this.yurikAPI(location.wiki).backLinks(location.title, nameSpaces, redirect, limit, continueKey);
    }

    public EmbeddedInResult embeddedIn(Location location, List<NameSpace> nameSpaces, boolean redirect, int limit, String continueKey) throws MediaWikiException {
        return this.yurikAPI(location.wiki).embeddedIn(location.title, nameSpaces, redirect, limit, continueKey);
    }

    public ImageUsageResult imageUsage(Location location, List<NameSpace> nameSpaces, boolean redirect, int limit, String continueKey) throws MediaWikiException {
        return this.yurikAPI(location.wiki).imageUsage(location.title, nameSpaces, redirect, limit, continueKey);
    }

    public ExtUrlUsageResult extUrlUsage(String wiki, String protocol, String query, List<NameSpace> nameSpaces, int limit, String continueKey) throws MediaWikiException {
        return this.yurikAPI(wiki).extUrlUsage(protocol, query, nameSpaces, limit, continueKey);
    }

    public LogEventsResult logEvents(String wiki, Date start, Date end, boolean newer, String user, String title, int limit) throws MediaWikiException {
        return this.yurikAPI(wiki).logEvents(start, end, newer, user, title, limit);
    }

    public RecentChangesResult recentChanges(String wiki, List<NameSpace> nameSpaces, Date start, Date end, boolean newer, int limit) throws MediaWikiException {
        return this.yurikAPI(wiki).recentChanges(nameSpaces, start, end, newer, limit);
    }

    public WatchListResult watchList(String wiki, List<NameSpace> nameSpaces, Date start, Date end, boolean newer, int limit) throws MediaWikiException {
        return this.yurikAPI(wiki).watchList(nameSpaces, start, end, newer, limit);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setupProxy() {
        Properties sysProps = System.getProperties();
        String proxyHost = sysProps.getProperty("http.proxyHost");
        String proxyPort = sysProps.getProperty("http.proxyPort");
        String nonProxyHosts = sysProps.getProperty("http.nonProxyHosts");
        if (proxyHost != null && proxyPort != null) {
            int portNum;
            try {
                portNum = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException e) {
                this.logger.error("system property http.proxyPort is not a number: " + proxyPort, (Throwable)e);
                return;
            }
            this.logger.info("using system proxy: " + proxyHost + ":" + proxyPort);
            this.configureProxy(proxyHost, portNum, null, null, nonProxyHosts);
            return;
        }
        if (proxyHost != null || proxyPort != null) {
            this.logger.info("proxy not set, both http.proxyHost and http.proxyPort have to be set");
        }
        String proxyStr = null;
        try {
            proxyStr = System.getenv("http_proxy");
        }
        catch (Throwable t) {
            this.logger.info("cannot get environment variable: http_proxy", t);
        }
        if (proxyStr != null) {
            URL url;
            try {
                url = new URL(proxyStr);
            }
            catch (MalformedURLException e) {
                this.logger.error("environment variable http_proxy is not an URL: " + proxyStr, (Throwable)e);
                return;
            }
            this.logger.info("using environment proxy: " + proxyStr);
            this.configureProxy(url.getHost(), url.getPort(), null, null, nonProxyHosts);
            return;
        }
    }

    public void configureProxy(String host, int port, String user, String password, String nonProxyHosts) {
        if (host != null) {
            UsernamePasswordCredentials credentials;
            this.logger.info("using proxy " + host + ":" + port);
            this.client.getHostConfiguration().setProxy(host, port);
            HttpState httpState = this.client.getState();
            AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            if (user != null) {
                this.logger.info("using proxy user " + user);
                credentials = new UsernamePasswordCredentials(user, password);
            } else {
                this.logger.info("not using proxy authentication");
                credentials = null;
            }
            httpState.setProxyCredentials(authScope, credentials);
        } else {
            this.logger.info("proxy usage disabled");
            this.client.getHostConfiguration().setProxyHost(null);
        }
        this.logger.info("proxy usage disabled for hosts: " + nonProxyHosts);
        this.manager.setNonProxyHosts(nonProxyHosts);
    }

    public void httpCredentials(String wiki, String user, String password) throws UnsupportedWikiException {
        this.client.getParams().setAuthenticationPreemptive(true);
        Site site = this.configManager.getSite(wiki);
        HttpState httpState = this.client.getState();
        AuthScope authScope = new AuthScope(site.hostName, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
        UsernamePasswordCredentials credentials = user != null && password != null ? new UsernamePasswordCredentials(user, password) : null;
        httpState.setCredentials(authScope, credentials);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLog(PrintWriter log) {
        this.logger = new Logger(log, MediaWiki.class);
    }

    public void setLog(PrintStream log) {
        this.logger = new Logger(log, MediaWiki.class);
    }

    public HttpClient getClient() {
        return this.client;
    }

    private Connection connection(String wiki) throws UnsupportedWikiException {
        Connection connection = this.connections.get(wiki);
        if (connection == null) {
            Site site = this.configManager.getSite(wiki);
            connection = new Connection(this.client, site);
            this.connections.put(wiki, connection);
        }
        return connection;
    }
}

