/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.psammead.mwapi.config.ConfigInfo;
import net.psammead.mwapi.config.ConfigSerializer;
import net.psammead.mwapi.config.Family;
import net.psammead.mwapi.config.Site;
import net.psammead.mwapi.scrapper.Scrapper;
import net.psammead.mwapi.scrapper.SiteInfo;
import net.psammead.util.IOUtil;
import net.psammead.util.Logger;

public class Configurator {
    private static final Logger logger = new Logger(Configurator.class);
    private Scrapper scrapper = new Scrapper();

    public void generate(File outputDir, String familyName, String familyShortcut, String[] languages, String protocol, String host, String rawPath, String prettyPath, String apiPath, String charSet, String uselang) throws IOException {
        outputDir.mkdirs();
        File familyFile = new File(outputDir, ConfigInfo.familyFileName(familyName));
        Family family = this.family(familyName, familyShortcut, languages);
        String familyCode = ConfigSerializer.serializeFamily(family);
        logger.info("writing " + familyFile);
        try {
            IOUtil.writeStringToFile((File)familyFile, (String)familyCode, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error("could not create " + familyFile, (Throwable)e);
            throw e;
        }
        if (languages != null) {
            for (int i = 0; i < languages.length; ++i) {
                String language = languages[i];
                File siteFile = new File(outputDir, ConfigInfo.siteFileName(familyName, language));
                try {
                    Site site = this.site(familyName, language, protocol, host.replaceAll("\\*", language), rawPath, prettyPath, apiPath, charSet, uselang);
                    String siteCode = ConfigSerializer.serializeSite(site);
                    logger.info("writing " + siteFile);
                    IOUtil.writeStringToFile((File)siteFile, (String)siteCode, (String)"UTF-8");
                    continue;
                }
                catch (IOException e) {
                    logger.error("could not create " + siteFile, (Throwable)e);
                    throw e;
                }
            }
        } else {
            File siteFile = new File(outputDir, ConfigInfo.siteFileName(familyName, null));
            try {
                Site site = this.site(familyName, null, protocol, host, rawPath, prettyPath, apiPath, charSet, uselang);
                String siteCode = ConfigSerializer.serializeSite(site);
                logger.info("writing " + siteFile);
                IOUtil.writeStringToFile((File)siteFile, (String)siteCode, (String)"UTF-8");
            }
            catch (IOException e) {
                logger.error("could not create " + siteFile, (Throwable)e);
                throw e;
            }
        }
    }

    private Family family(String name, String shortcut, String[] supportedLanguages) {
        boolean multilingual = supportedLanguages != null;
        String defaultLanguage = null;
        HashSet<String> supportedLanguagesSet = null;
        if (multilingual) {
            if (supportedLanguages == null) {
                throw new RuntimeException("supportedLanguages may not be null for multilingual wikis");
            }
            defaultLanguage = supportedLanguages[0];
            supportedLanguagesSet = new HashSet<String>();
            for (int i = 0; i < supportedLanguages.length; ++i) {
                supportedLanguagesSet.add(supportedLanguages[i]);
            }
        }
        return new Family(name, shortcut, multilingual, defaultLanguage, supportedLanguagesSet);
    }

    private Site site(String family, String language, String protocol, String host, String rawPath, String prettyPath, String apiPath, String charSet, String uselang) throws IOException {
        SiteInfo siteInfo = this.scrapper.fetchSiteInfo(protocol, host, prettyPath);
        Map<String, String> messages_en = this.scrapper.fetchMessages(protocol, host, rawPath, "en");
        Map<String, String> messages_use = this.scrapper.fetchMessages(protocol, host, rawPath, uselang);
        HashMap<String, String> messages = new HashMap<String, String>();
        for (int i = 0; i < ConfigInfo.MESSAGE_NAMES.length; ++i) {
            String val2;
            String key = ConfigInfo.MESSAGE_NAMES[i];
            String val1 = messages_en.get(key);
            if (val1 != null) {
                messages.put(key, val1);
            }
            if ((val2 = messages_use.get(key)) == null) continue;
            messages.put(key, val2);
        }
        return new Site(family, language, protocol, host, rawPath, prettyPath, apiPath, charSet, siteInfo.titleCase, uselang, siteInfo.nameSpaces, siteInfo.specialPages, messages);
    }
}

