/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public final class UIUtil {
    public static void framed(JComponent component) {
        UIUtil.framed(component, true, true);
    }

    public static void framed(JComponent component, boolean exitOnClose, boolean closeOnEscape) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        Container content = frame.getContentPane();
        content.setLayout(new BorderLayout());
        content.add((Component)component, "Center");
        frame.setVisible(true);
        if (closeOnEscape) {
            UIUtil.disposeOnEscape(frame);
        }
    }

    public static void disposeOnEscape(RootPaneContainer container) {
        if (!(container instanceof Window)) {
            return;
        }
        final Window window = (Window)((Object)container);
        container.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                window.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public static void edtWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void edtRun(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

