/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.json;

import java.io.File;
import java.io.IOException;
import net.psammead.util.IOUtil;
import net.psammead.util.json.JSONDecodeException;
import net.psammead.util.json.JSONDecoder;

public class JSONTest {
    public static void main(String[] args) throws IOException {
        JSONTest.testStrings();
        String text = IOUtil.readStringFromFile(new File("/home/daniel/Project/current/util/versatz/rc_api.php"), "ISO-8859-1");
        JSONTest.testString(text);
    }

    private static void testStrings() {
        JSONTest.testString("1");
        JSONTest.testString("-1");
        JSONTest.testString("1.0");
        JSONTest.testString("-1.0");
        JSONTest.testString("1.0e2");
        JSONTest.testString("1.0e+2");
        JSONTest.testString("1.0e-2");
        JSONTest.testString("1.0E2");
        JSONTest.testString("\"hallo\"");
        JSONTest.testString("\"h\\u00ffllo\"");
        JSONTest.testString("\"h\\/\"");
        JSONTest.testString("\"ha\\nlo\"");
        JSONTest.testString("[]");
        JSONTest.testString("[1]");
        JSONTest.testString("[1,2]");
        JSONTest.testString("[1,2,3]");
        JSONTest.testString("{}");
        JSONTest.testString("{\"1\":2}");
        JSONTest.testString("{\"1\":2,\"2\":3}");
        JSONTest.testString("[{\"1\":1},{\"2\":2},{\"3\":3}]");
        JSONTest.testString("{[1]:[2],[3]:[4],[5]:[6]}");
        JSONTest.testString("\"h\\u00fgllo\"");
        JSONTest.testString("/*xxx*/1");
        JSONTest.testString("1/*xxx*/");
        JSONTest.testString("/*xxx*/1/*xxx*/");
        JSONTest.testString("//test\n1");
        JSONTest.testString("1\n//test");
        JSONTest.testString("//test");
        JSONTest.testString("{1}");
    }

    private static void testString(String text) {
        try {
            System.err.println(text);
            System.err.println("\t" + JSONDecoder.decode(text));
        }
        catch (JSONDecodeException e) {
            System.err.println("\texpected:\t" + e.expectation);
            System.err.println("\tat offset:\t" + e.offset);
            System.err.println("\tlooking at:\t" + e.lookingAt());
        }
        System.err.println("");
    }
}

