/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.HashSet;
import java.util.Set;
import net.psammead.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetUtil {
    private SetUtil() {
    }

    public static <T> Set<T> create(Iterable<T> in) {
        HashSet<T> out = new HashSet<T>();
        for (T element : in) {
            out.add(element);
        }
        return out;
    }

    public static <T, X extends T> Set<T> single(X element) {
        HashSet<X> out = new HashSet<X>();
        out.add(element);
        return out;
    }

    public static <T> Set<T> filter(Set<T> in, Filter<T> filter) {
        HashSet<T> out = new HashSet<T>();
        for (T element : in) {
            if (!filter.accept(element)) continue;
            out.add(element);
        }
        return out;
    }

    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        HashSet<T> out = new HashSet<T>();
        out.addAll(a);
        out.addAll(b);
        return out;
    }

    public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
        HashSet<T> out = new HashSet<T>();
        out.addAll(a);
        out.retainAll(b);
        return out;
    }

    public static <T> Set<T> without(Set<T> a, Set<T> b) {
        HashSet<T> out = new HashSet<T>();
        out.addAll(a);
        out.removeAll(b);
        return out;
    }

    public static <T> Set<T> difference(Set<T> a, Set<T> b) {
        return SetUtil.without(SetUtil.union(a, b), SetUtil.intersection(a, b));
    }
}

