/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import net.psammead.util.ScanException;

public class Scan {
    public static final int POSITION_ILLEGAL = -1;
    public static final String TAB = "\t";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String WHITE = " \t\r\n";
    public static final String ALPHA = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String BIN_NUM = "01";
    public static final String DEC_NUM = "0123456789";
    public static final String HEX_NUM = "0123456789abcdefABCDEF";
    public static final String ALPHANUM = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private String data;
    private int position;
    private int back;
    private int length;

    public Scan() {
        this.setText("");
    }

    public Scan(String text) {
        this.setText(text);
    }

    public void setText(String data) {
        this.data = data;
        this.position = 0;
        this.back = 0;
        this.length = data.length();
        if (this.length == 0) {
            this.position = -1;
        }
    }

    public String getText() {
        return this.data;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void movePosition(int delta) {
        this.position += delta;
    }

    public boolean isFinished() {
        return this.position == -1;
    }

    public int remainingChars() {
        if (this.position == -1) {
            return -1;
        }
        return this.length - this.position;
    }

    public int lineNumber() {
        if (this.length == 0) {
            return -1;
        }
        int save = this.position;
        int line = 0;
        this.position = 0;
        while (this.position < save) {
            this.line();
            if (!this.eol()) break;
            ++line;
        }
        this.position = save;
        return line;
    }

    public String tag() throws ScanException {
        StringBuilder s;
        block3: {
            if (!this.is("<")) {
                return "";
            }
            s = new StringBuilder();
            do {
                s.append(this.scan(">\""));
                if (this.is(">")) break block3;
                if (!this.is("\"")) {
                    throw new ScanException("illegal quote: missing \"", this.data, this.position);
                }
                s.append("\"");
                s.append(this.scan("\""));
                s.append("\"");
            } while (this.is("\""));
            throw new ScanException("illegal quote: missing \"", this.data, this.position);
        }
        return s.toString();
    }

    public String entity() throws ScanException {
        if (!this.is("&")) {
            return "";
        }
        String s = this.scan(" \t\r\n<&;");
        if (!this.is(";")) {
            throw new ScanException("illegal entity: missing ;", this.data, this.position);
        }
        return "&" + s + ";";
    }

    public String text() {
        return this.scan("<");
    }

    public String skip() {
        return this.take(WHITE);
    }

    public String word() {
        return this.scan(WHITE);
    }

    public String line() {
        return this.scan(CRLF);
    }

    public boolean eol() {
        if (this.is(CRLF)) {
            return true;
        }
        if (this.is(LF)) {
            return true;
        }
        return this.is(CR);
    }

    public long dec() throws ScanException {
        int p = this.position;
        String s = (this.is("-") ? "-" : "") + this.take(DEC_NUM, 20);
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            this.position = p;
            throw new ScanException("illegal number format", this.data, this.position);
        }
    }

    public long hex() throws ScanException {
        int p = this.position;
        String s = this.take(HEX_NUM, 16);
        try {
            return Long.parseLong(s, 16);
        }
        catch (NumberFormatException e) {
            this.position = p;
            throw new ScanException("illegal number format", this.data, this.position);
        }
    }

    public long bin() throws ScanException {
        int p = this.position;
        String s = this.take(BIN_NUM, 64);
        try {
            return Long.parseLong(s, 2);
        }
        catch (NumberFormatException e) {
            this.position = p;
            throw new ScanException("illegal number format", this.data, this.position);
        }
    }

    public String stopAt(String word) {
        int z = word.length();
        if (z < 2) {
            return this.scan(word);
        }
        String first = word.substring(0, 1);
        StringBuilder out = new StringBuilder();
        while (true) {
            out.append(this.scan(first));
            if (this.isFinished() || this.peek(z).equals(word)) break;
            this.is(first);
            out.append(first);
        }
        return out.toString();
    }

    public boolean is(String them) {
        int len = them.length();
        if (this.position == -1) {
            return false;
        }
        if (len == 0) {
            return true;
        }
        if (this.position + len > this.length) {
            return false;
        }
        String maybe = this.data.substring(this.position, this.position + len);
        if (maybe.equals(them)) {
            this.back = this.position;
            this.position += len;
            if (this.position >= this.length) {
                this.position = -1;
            }
            return true;
        }
        return false;
    }

    public String take(String these) {
        char c;
        if (this.position == -1) {
            return "";
        }
        if (these.length() == 0) {
            return "";
        }
        this.back = this.position;
        while (this.position < this.length && these.indexOf(c = this.data.charAt(this.position)) != -1) {
            ++this.position;
        }
        if (this.position == this.back) {
            return "";
        }
        String s = this.data.substring(this.back, this.position);
        if (this.position >= this.length) {
            this.position = -1;
        }
        return s;
    }

    public String take(String these, int maxLength) {
        char c;
        if (this.position == -1) {
            return "";
        }
        if (these.length() == 0) {
            return "";
        }
        this.back = this.position;
        while (this.position < this.length && maxLength > 0 && these.indexOf(c = this.data.charAt(this.position)) != -1) {
            ++this.position;
            --maxLength;
        }
        if (this.position == this.back) {
            return "";
        }
        String s = this.data.substring(this.back, this.position);
        if (this.position >= this.length) {
            this.position = -1;
        }
        return s;
    }

    public String scan(String upto) {
        char c;
        if (this.position == -1) {
            return "";
        }
        if (upto.length() == 0) {
            String s = this.data.substring(this.position);
            this.position = -1;
            return s;
        }
        this.back = this.position;
        while (this.position < this.length && upto.indexOf(c = this.data.charAt(this.position)) == -1) {
            ++this.position;
        }
        if (this.position == this.back) {
            return "";
        }
        String s = this.data.substring(this.back, this.position);
        if (this.position >= this.length) {
            this.position = -1;
        }
        return s;
    }

    public String scan(String upto, int maxLength) {
        char c;
        if (this.position == -1) {
            return "";
        }
        if (upto.length() == 0) {
            String s = this.data.substring(this.position);
            this.position = -1;
            return s;
        }
        this.back = this.position;
        while (this.position < this.length && maxLength > 0 && upto.indexOf(c = this.data.charAt(this.position)) == -1) {
            ++this.position;
            --maxLength;
        }
        if (this.position == this.back) {
            return "";
        }
        String s = this.data.substring(this.back, this.position);
        if (this.position >= this.length) {
            this.position = -1;
        }
        return s;
    }

    public String remainder() {
        if (this.position == -1) {
            return "";
        }
        String s = this.data.substring(this.position);
        this.position = -1;
        return s;
    }

    public int read() {
        if (this.position == -1) {
            return -1;
        }
        char c = this.data.charAt(this.position);
        ++this.position;
        if (this.position >= this.length) {
            this.position = -1;
        }
        return c;
    }

    public String read(int len) {
        if (this.position == -1) {
            return "";
        }
        int max = this.length - this.position;
        if (len > max) {
            len = max;
        }
        int p2 = this.position;
        this.position += len;
        if (this.position >= this.length) {
            this.position = -1;
        }
        return this.data.substring(p2, p2 + len);
    }

    public int peek() {
        if (this.position >= this.length) {
            this.position = -1;
        }
        if (this.position == -1) {
            return -1;
        }
        return this.data.charAt(this.position);
    }

    public String peek(int len) {
        if (this.position == -1) {
            return "";
        }
        int max = this.length - this.position;
        if (len > max) {
            len = max;
        }
        return this.data.substring(this.position, this.position + len);
    }
}

