package net.psammead.util.ui;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JComponent;
import javax.swing.JFrame;

public final class UIUtil {
	/** display a {@link JComponent} in a {@link JFrame} and exit the application when closed */
	public static void framed(JComponent component) {
		framed(component, true);
	}
	
	/** display a {@link JComponent} in a {@link JFrame} */
	public static void framed(JComponent component, boolean exitOnClose) {
		JFrame frame	= new JFrame();
		frame.setDefaultCloseOperation(exitOnClose
				? JFrame.EXIT_ON_CLOSE
				: JFrame.DISPOSE_ON_CLOSE);
		frame.setSize(800, 600);
		frame.setLocationRelativeTo(null);
		
		Container content = frame.getContentPane();
		content.setLayout(new BorderLayout());
		content.add(component, BorderLayout.CENTER);
		
		frame.setVisible(true);
	}
}
