package net.psammead.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ToString {
	public static final String	NULL_LITERAL	= "<null>";
	
    private Object		object;
    private List<Part>	parts;

    public ToString(Object object) {
        this.object	= object;
        parts	= new ArrayList<Part>();
    }
    
    /** appends a Part */
    public ToString append(String name, Object value) {
        parts.add(new Part(name, value));
        return this;
    }
    
    /** appends a public field Part */
    public ToString appendField(String name) {
    	Class<?>	objectClass = object.getClass();
    	Field[] 	classFields	= objectClass.getFields();
    	for (Field field : classFields) {
    		if (field.getName().equals(name)) {
    			if (!Modifier.isPublic(field.getModifiers())) {
    				//  TODO maybe use field.setAccessible(true);
    				throw new IllegalArgumentException("field is not public: " + name + " in class: " + objectClass.getName());
    			}
    			Object value;
				try {
					value = field.get(object);
					append(name, value);
					return this;
				}
				catch (IllegalAccessException e) {
					throw new RuntimeException("field not accessible: " + name + " in class: " + objectClass.getName(), e);
				}
    		}
    	}
    	throw new IllegalArgumentException("field does not exist: " + name + " in class: " + objectClass.getName());
    }
    
    @Override
	public String toString() {
    	if (object == null)	return "null";
        StringBuilder   b = new StringBuilder();
        String	separator	= ", ";
    	for (Part part : parts) {
        	b.append(part.name);
        	b.append('=');
        	b.append(stringify(part.value));
        	b.append(separator);
        }
        if (b.length() > separator.length()) {
        	b.setLength(b.length() - separator.length());
        }
        return DebugUtil.shortClassName(object) + "{ " + b.toString() + " }";
    }
    
    private Object stringify(Object value) {
	  		 if (value == null)					return NULL_LITERAL;
	  	else if (value instanceof List)			return stringify((List<?>)value);
	  	else if (value instanceof Set)			return stringify((Set<?>)value);
	  	else if (value instanceof Map)			return stringify((Map<?, ?>)value);
	  	else if (value instanceof Collection) 	return stringify((Collection<?>)value);
	  	else if (value instanceof String) 		return JavaLiteral.encodeString((String)value);
	  	else if (value instanceof Character) 	return JavaLiteral.encodeChar((Character)value);
	  	else									return value.toString();
	}
    
    private String stringify(List<?> value) {
    	return value.toString();	// TODO
    }
    private String stringify(Set<?> value) {
    	return value.toString();	// TODO
    }
    private String stringify(Map<?, ?> value) {
    	return value.toString();	// TODO
    }
    private String stringify(Collection<?> value) {
    	return value.toString();	// TODO
    }
    
    private class Part {
        public final String name;
        public final Object value;
        
        public Part(String name, Object value) {
            this.name   = name;
            this.value  = value;
        }
    }
}