/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action.response;

import java.util.regex.Pattern;
import net.psammead.util.StringUtil;
import net.psammead.util.XMLCodec;

public class ResponsePattern {
    public static final int WILD_CODE = -1;
    public static final Pattern WILD_PATTERN = null;
    public final int code;
    public final Pattern pattern;

    public ResponsePattern(int code) {
        this(code, WILD_PATTERN);
    }

    public ResponsePattern(int code, String pattern) {
        this(-1, Pattern.compile("(?m).*" + StringUtil.escapeRegexp((String)pattern) + ".*"));
    }

    public ResponsePattern(int code, Pattern pattern) {
        this.code = code;
        this.pattern = pattern;
    }

    public boolean match(int responseCode, String responseBody) {
        return !(this.code != -1 && this.code != responseCode || this.pattern != WILD_PATTERN && !this.match(responseBody));
    }

    private boolean match(String responseBody) {
        String decoded = XMLCodec.decodeBody((String)responseBody);
        boolean matches = this.pattern.matcher(decoded).matches();
        return matches;
    }

    public String toString() {
        return "ResponsePattern{ code=" + this.code + ", pattern=" + this.pattern + " }";
    }
}

