/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action.parser;

import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormField;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import java.net.URL;
import net.psammead.mwapi.Location;
import net.psammead.mwapi.connection.URLManager;
import net.psammead.mwapi.net.IllegalFormException;
import net.psammead.mwapi.net.JerichoUtil;
import net.psammead.mwapi.ui.Page;
import net.psammead.mwapi.ui.UnsupportedURLException;
import net.psammead.util.TextUtil;

public class ParsedEditForm {
    public final boolean conflict;
    public final Location location;
    public final String body;
    public final String editTime;
    public final String startTime;
    public final String editToken;
    public final boolean watchThis;
    public final boolean watchKnown;

    public Page page(boolean fresh) {
        return new Page(this.location, this.body, this.editTime, this.startTime, this.editToken, this.watchThis, this.watchKnown, fresh);
    }

    public ParsedEditForm(URLManager urlManager, URL formURL, Source source) throws IllegalFormException {
        Element form = JerichoUtil.fetchForm((Segment)source, "editform", "editform", -1);
        FormFields fields = form.findFormFields();
        try {
            URL url = JerichoUtil.fetchActionURL(formURL, form);
            this.location = urlManager.anyURLToLocation(url);
            if (this.location == null) {
                throw new IllegalFormException("actionURL cannot be converted to a title: " + url);
            }
        }
        catch (UnsupportedURLException e) {
            throw new IllegalFormException("encoding problem url", e);
        }
        this.body = TextUtil.unixLF((String)JerichoUtil.fetchStringField(fields, "wpTextbox1"));
        this.conflict = fields.get("wpTextbox2") != null;
        this.editTime = JerichoUtil.fetchStringField(fields, "wpEdittime");
        FormField wpStarttime = fields.get("wpStarttime");
        this.startTime = wpStarttime != null ? (String)wpStarttime.getValues().iterator().next() : null;
        FormField wpEditToken = fields.get("wpEditToken");
        this.editToken = wpEditToken != null ? (String)wpEditToken.getValues().iterator().next() : null;
        FormField wpWatchthis = fields.get("wpWatchthis");
        if (wpWatchthis != null) {
            this.watchThis = wpWatchthis.getValues().size() != 0;
            this.watchKnown = true;
        } else {
            this.watchThis = false;
            this.watchKnown = false;
        }
    }
}

