/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import net.psammead.mwapi.ui.ProgressCallback;

public class ProgressFileInputStream
extends FilterInputStream {
    private ProgressCallback progressListener;
    private long doneBytes;
    private long maxBytes;

    public ProgressFileInputStream(File file, ProgressCallback progressListener) throws FileNotFoundException {
        super(new FileInputStream(file));
        this.progressListener = progressListener;
        this.doneBytes = 0L;
        this.maxBytes = file.length();
    }

    public int read() throws IOException {
        int tmp = super.read();
        ++this.doneBytes;
        if (this.progressListener != null) {
            this.progressListener.bytesWritten(this.doneBytes, this.maxBytes);
        }
        return tmp;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int tmp = super.read(b, off, len);
        this.doneBytes += (long)len;
        if (this.progressListener != null) {
            this.progressListener.bytesWritten(this.doneBytes, this.maxBytes);
        }
        return tmp;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

