/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.net;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormField;
import au.id.jericho.lib.html.FormFields;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import net.psammead.mwapi.net.IllegalFormException;
import net.psammead.mwapi.net.JerichoLogger;
import net.psammead.util.Logger;

public final class JerichoUtil {
    private JerichoUtil() {
    }

    public static Source createSource(String html, Logger logger) {
        Source source = new Source((CharSequence)html);
        source.setLogger((au.id.jericho.lib.html.Logger)new JerichoLogger(logger));
        return source;
    }

    public static Element firstElement(Segment source, String tagName) {
        List elements = source.findAllElements(tagName);
        if (elements.size() == 0) {
            return null;
        }
        return (Element)elements.get(0);
    }

    public static String firstElementText(Segment source, String tagName) {
        return JerichoUtil.firstElement(source, tagName).getTextExtractor().toString();
    }

    public static Element fetchElementByAttributeValue(Segment parent, String tagName, String attributeName, String value) throws IllegalFormException {
        Element element = JerichoUtil.findElementByAttributeValue(parent, tagName, attributeName, value);
        if (element == null) {
            throw new IllegalFormException("element not found: " + tagName + "[@" + attributeName + "=\"" + value + "\"]");
        }
        return element;
    }

    public static Element fetchForm(Segment segment, String name, String id, int index) throws IllegalFormException {
        Element form = JerichoUtil.findForm(segment, name, id, index);
        if (form == null) {
            throw new IllegalFormException("form not found: " + name);
        }
        return form;
    }

    public static URL fetchActionURL(URL formURL, Element form) throws IllegalFormException {
        String actionPath = JerichoUtil.fetchAttributeValue(form, "action");
        try {
            return new URL(formURL, actionPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalFormException("action url is broken", e);
        }
    }

    public static boolean fetchBooleanField(FormFields fields, String name) throws IllegalFormException {
        FormField field = fields.get(name);
        if (field == null) {
            throw new IllegalFormException("field not found: " + name);
        }
        return field.getValues().size() != 0;
    }

    public static String fetchStringField(FormFields fields, String name) throws IllegalFormException {
        FormField field = fields.get(name);
        if (field == null) {
            throw new IllegalFormException("field not found: " + name);
        }
        Collection values = field.getValues();
        if (values.size() == 0) {
            throw new IllegalFormException("values empty for field: " + name);
        }
        return (String)values.iterator().next();
    }

    public static String fetchAttributeValue(StartTag startTag, String name) throws IllegalFormException {
        String value = startTag.getAttributeValue(name);
        if (value == null) {
            throw new IllegalFormException("attribute not found: " + name);
        }
        return value;
    }

    public static String fetchAttributeValue(Element element, String name) throws IllegalFormException {
        String value = element.getAttributeValue(name);
        if (value == null) {
            throw new IllegalFormException("attribute not found: " + name);
        }
        return value;
    }

    public static Element findElementByAttributeValue(Segment parent, String tagName, String attributeName, String value) {
        List children = parent.findAllElements(tagName);
        for (Element child : children) {
            Attribute attribute;
            Attributes attributes = child.getAttributes();
            if (attributes == null || (attribute = attributes.get(attributeName)) == null || !value.equals(attribute.getValue())) continue;
            return child;
        }
        return null;
    }

    public static Element findForm(Segment segment, String name, String id, int index) {
        List forms = segment.findAllElements("form");
        if (name != null) {
            for (Element form : forms) {
                if (!name.equals(form.getAttributeValue("name"))) continue;
                return form;
            }
        }
        if (id != null) {
            for (Element form : forms) {
                if (!id.equals(form.getAttributeValue("id"))) continue;
                return form;
            }
        }
        if (index >= 0 && index < forms.size()) {
            return (Element)forms.get(index);
        }
        return null;
    }

    public static void debugForms(String text) {
        Source source = new Source((CharSequence)text);
        List formElements = source.findAllElements("form");
        for (Element formElement : formElements) {
            Attributes formAttributes = formElement.getStartTag().getAttributes();
            if (formAttributes == null) continue;
            System.err.println("---------------------------------------------------");
            System.err.println("### " + formAttributes.get("name"));
            FormFields formFields = formElement.findFormFields();
            for (FormField formField : formFields) {
                System.err.println(formField.getDebugInfo());
            }
        }
    }

    public static String decodedTextOnly(Source source, Segment segment) {
        StringBuffer sb = new StringBuffer(segment.length());
        int textBegin = segment.getBegin();
        List tags = segment.findAllTags();
        for (Tag tag : tags) {
            int textEnd = tag.getBegin();
            if (textEnd < textBegin) continue;
            while (textBegin < textEnd) {
                sb.append(source.charAt(textBegin++));
            }
            if (tag.getTagType() == StartTagType.NORMAL) {
                StartTag startTag = (StartTag)tag;
                if (tag.getName() == "script" || tag.getName() == "style") {
                    textBegin = startTag.getElement().getEnd();
                    continue;
                }
            }
            textBegin = tag.getEnd();
        }
        while (textBegin < segment.getEnd()) {
            sb.append(source.charAt(textBegin++));
        }
        String decodedText = CharacterReference.decode((CharSequence)sb, (boolean)false);
        return decodedText;
    }
}

