/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.ui;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public class GridBagUtil {
    public static void defaults(GridBagConstraints c) {
        c.gridx = -1;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.ipadx = 0;
        c.ipady = 0;
    }

    public static GridBagConstraints constraints(String code) {
        GridBagConstraints c = new GridBagConstraints();
        GridBagUtil.constrain(c, code);
        return c;
    }

    public static void constrain(GridBagConstraints c, String code) {
        String[] tokens = code.trim().split("\\s+");
        if (tokens.length % 2 != 0) {
            throw new SyntaxError("illegal number of tokens: " + code + ", expected an even number of tokens");
        }
        for (int i = 0; i < tokens.length; i += 2) {
            String selector = tokens[i];
            String value = tokens[i + 1];
            if ("at".equals(selector)) {
                GridBagUtil.at(c, value);
                continue;
            }
            if ("size".equals(selector)) {
                GridBagUtil.size(c, value);
                continue;
            }
            if ("weight".equals(selector)) {
                GridBagUtil.weight(c, value);
                continue;
            }
            if ("ipad".equals(selector)) {
                GridBagUtil.ipad(c, value);
                continue;
            }
            if ("insets".equals(selector)) {
                GridBagUtil.insets(c, value);
                continue;
            }
            if ("anchor".equals(selector)) {
                GridBagUtil.anchor(c, value);
                continue;
            }
            if ("fill".equals(selector)) {
                GridBagUtil.fill(c, value);
                continue;
            }
            throw new SyntaxError("illegal selector: " + selector + ", expected at|size|weight|ipad|insets|anchor|fill");
        }
    }

    private static void at(GridBagConstraints c, String value) {
        try {
            String[] tuple = GridBagUtil.tuple(value, 2);
            c.gridx = tuple[0].equals("relative") ? -1 : Integer.parseInt(tuple[0]);
            c.gridy = tuple[1].equals("relative") ? -1 : Integer.parseInt(tuple[1]);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("illegal at value: " + value + ", expected relative|<int>", e);
        }
    }

    private static void size(GridBagConstraints c, String value) {
        try {
            String[] tuple = GridBagUtil.tuple(value, 2);
            int n = tuple[0].equals("relative") ? -1 : (c.gridwidth = tuple[0].equals("remainder") ? 0 : Integer.parseInt(tuple[0]));
            c.gridheight = tuple[1].equals("relative") ? -1 : (tuple[1].equals("remainder") ? 0 : Integer.parseInt(tuple[1]));
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("illegal size value: " + value + ", expected relative|remainder|<int>", e);
        }
    }

    private static void weight(GridBagConstraints c, String value) {
        try {
            String[] tuple = GridBagUtil.tuple(value, 2);
            double d = tuple[0].equals("minimum") ? 0.0 : (tuple[0].equals("medium") ? 0.5 : (c.weightx = tuple[0].equals("maximum") ? 1.0 : Double.parseDouble(tuple[0])));
            c.weighty = tuple[1].equals("minimum") ? 0.0 : (tuple[1].equals("medium") ? 0.5 : (tuple[1].equals("maximum") ? 1.0 : Double.parseDouble(tuple[1])));
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("illegal weight value: " + value + ", expected minimum|medium|maximum|<double>/minimum|medium|maximum|<double>", e);
        }
    }

    private static void ipad(GridBagConstraints c, String value) {
        try {
            String[] tuple = GridBagUtil.tuple(value, 2);
            c.ipadx = Integer.parseInt(tuple[0]);
            c.ipady = Integer.parseInt(tuple[1]);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("illegal ipad value: " + value + ", expected <int>/<int>", e);
        }
    }

    private static void insets(GridBagConstraints c, String value) {
        try {
            String[] tuple = GridBagUtil.tuple(value, 4);
            c.insets = new Insets(Integer.parseInt(tuple[0]), Integer.parseInt(tuple[1]), Integer.parseInt(tuple[2]), Integer.parseInt(tuple[3]));
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("illegal insets value: " + value + ", expected <int>/<int>/<int>/<int>", e);
        }
    }

    private static void anchor(GridBagConstraints c, String value) {
        if ("center".equals(value)) {
            c.anchor = 10;
        } else if ("north".equals(value)) {
            c.anchor = 11;
        } else if ("south".equals(value)) {
            c.anchor = 15;
        } else if ("east".equals(value)) {
            c.anchor = 13;
        } else if ("west".equals(value)) {
            c.anchor = 17;
        } else if ("northeast".equals(value)) {
            c.anchor = 12;
        } else if ("northwest".equals(value)) {
            c.anchor = 18;
        } else if ("southeast".equals(value)) {
            c.anchor = 14;
        } else if ("southwest".equals(value)) {
            c.anchor = 16;
        } else if ("page-start".equals(value)) {
            c.anchor = 19;
        } else if ("page-end".equals(value)) {
            c.anchor = 20;
        } else if ("line-start".equals(value)) {
            c.anchor = 21;
        } else if ("line-end".equals(value)) {
            c.anchor = 22;
        } else if ("first-line-start".equals(value)) {
            c.anchor = 23;
        } else if ("first-line-end".equals(value)) {
            c.anchor = 24;
        } else if ("last-line-start".equals(value)) {
            c.anchor = 25;
        } else if ("last-line-end".equals(value)) {
            c.anchor = 26;
        } else {
            throw new SyntaxError("illegal anchor value: " + value + ", expected center|north|south|east|west|northeast|northwest|southeast|southwest|page-start|page-end|line-start|line-end|first-line-start|first-line-end|last-line-start|last-line-end");
        }
    }

    private static void fill(GridBagConstraints c, String value) {
        if ("none".equals(value)) {
            c.fill = 0;
        } else if ("horizontal".equals(value)) {
            c.fill = 2;
        } else if ("vertical".equals(value)) {
            c.fill = 3;
        } else if ("both".equals(value)) {
            c.fill = 1;
        } else {
            throw new SyntaxError("illegal fill value: " + value + ", expected none|horizontal|vertical|both");
        }
    }

    private static String[] tuple(String in, int length) {
        String[] out = in.split("/");
        if (out.length != length) {
            throw new SyntaxError("illegal " + length + "-tuple: " + in + ", expected <value>/<value>/...");
        }
        return out;
    }

    public static class SyntaxError
    extends RuntimeException {
        SyntaxError(String message) {
            super(message);
        }

        SyntaxError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

